/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.Scrollable;

public class ScrollableAllocationGraph
extends JLabel
implements Scrollable,
ActionListener {
    private int maxUnitIncrement = 1;
    private int height;
    private int width;
    private int barWidth;
    private int eventsPerBar;
    private int numBars;
    private Vector logs;
    private int[] rgbnormal;
    private int[] rgbselected;
    private int maximumSize;
    private int selectedPosition;
    private Graphics2D image;
    private MemoryBar[] bars;
    JPopupMenu popup;
    int popupOverBarIndex;
    public int viewX;
    public int viewY;
    private int markedBar;
    private int lastMarkedBar;

    public ScrollableAllocationGraph(Vector vector, int n, int n2, int n3) {
        this.logs = vector;
        this.eventsPerBar = n;
        this.barWidth = n2;
        this.height = n3;
        this.numBars = (int)Math.ceil((double)vector.size() / (double)n);
        this.width = this.numBars * n2;
        this.markedBar = -1;
        this.lastMarkedBar = -1;
        this.selectedPosition = -1;
        this.maximumSize = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = ((MemoryLog)vector.elementAt(i)).getSizeAfter();
            if (n4 <= this.maximumSize) continue;
            this.maximumSize = n4;
        }
        System.out.println("maximumSize = " + this.maximumSize);
        this.resize();
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.setAutoscrolls(true);
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Set Mark");
        jMenuItem.setActionCommand("setmark");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Remove Mark");
        jMenuItem.setActionCommand("removemark");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.addMouseListener(new PopupListener(this));
    }

    private void resize() {
        int n;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.image = bufferedImage.createGraphics();
        this.rgbnormal = new int[this.height * this.barWidth];
        int n2 = -45747;
        for (n = 0; n < this.height * this.barWidth; ++n) {
            this.rgbnormal[n] = n2;
        }
        this.rgbselected = new int[this.height * this.barWidth];
        n2 = -101;
        for (n = 0; n < this.height * this.barWidth; ++n) {
            this.rgbselected[n] = n2;
        }
        this.bars = new MemoryBar[this.numBars];
        for (n = 0; n < this.numBars; ++n) {
            int n3;
            int n4 = 0;
            int n5 = (n + 1) * this.eventsPerBar;
            if (this.logs.size() <= n5) {
                n5 = this.logs.size() - 1;
            }
            for (n3 = n * this.eventsPerBar + 1; n3 <= n5; ++n3) {
                int n6 = ((MemoryLog)this.logs.elementAt(n3)).getSizeAfter();
                if (n6 <= n4) continue;
                n4 = n6;
            }
            n3 = (int)((long)this.height * (long)n4 / (long)this.maximumSize);
            this.bars[n] = new MemoryBar(this.logs.subList(n * this.eventsPerBar + 1, n5 + 1), n4, n, n3);
            bufferedImage.setRGB(n * this.barWidth, this.height - n3, this.barWidth, n3, this.rgbnormal, 0, 1);
        }
        this.setIcon(new ImageIcon(bufferedImage));
        this.maxUnitIncrement = 10;
    }

    public JLabel getRowHeader() {
        BufferedImage bufferedImage = new BufferedImage(40, this.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.BLACK);
        graphics2D.clearRect(0, 0, 40, this.height);
        double d = (double)this.height / 50.0;
        double d2 = (double)this.maximumSize / d;
        System.out.print("Byte/Tick = " + d2);
        int n = d2 < 1.0E7 ? (int)(1000000.0 * Math.ceil(d2 / 1000000.0)) : (d2 < 1.0E8 ? (int)(1.0E7 * Math.ceil(d2 / 1.0E7)) : (int)(1.0E8 * Math.ceil(d2 / 1.0E8)));
        System.out.println(" -> " + n);
        graphics2D.drawLine(30, 0, 30, this.height);
        for (int i = 0; i < this.maximumSize; i += n) {
            int n2 = (int)((long)this.height * (long)i / (long)this.maximumSize) + 1;
            graphics2D.drawLine(25, this.height - n2, 35, this.height - n2);
            graphics2D.drawString("" + i / 1000000, 5, this.height - n2);
        }
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(bufferedImage));
        jLabel.setVerticalAlignment(1);
        return jLabel;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        n3 = n == 0 ? rectangle.x : rectangle.y;
        if (n2 < 0) {
            int n4 = n3 - n3 / this.maxUnitIncrement * this.maxUnitIncrement;
            return n4 == 0 ? this.maxUnitIncrement : n4;
        }
        return (n3 / this.maxUnitIncrement + 1) * this.maxUnitIncrement - n3;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - this.maxUnitIncrement;
        }
        return rectangle.height - this.maxUnitIncrement;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void selectPosition(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        int n4 = this.getMemoryBarIndex(mouseEvent);
        BufferedImage bufferedImage = (BufferedImage)((ImageIcon)this.getIcon()).getImage();
        if (this.selectedPosition != -1) {
            n2 = n3 = this.selectedPosition;
            if (this.lastMarkedBar != -1) {
                if (this.lastMarkedBar > this.selectedPosition) {
                    n3 = this.lastMarkedBar;
                } else {
                    n2 = this.lastMarkedBar;
                }
            }
            for (n = n2; n <= n3; ++n) {
                bufferedImage.setRGB(this.bars[n].position * this.barWidth, this.height - this.bars[n].pixels, this.barWidth, this.bars[n].pixels, this.rgbnormal, 0, 1);
            }
        }
        this.lastMarkedBar = this.markedBar;
        this.selectedPosition = n4;
        if (this.selectedPosition != -1) {
            n2 = n3 = this.selectedPosition;
            if (this.markedBar != -1) {
                if (this.markedBar > this.selectedPosition) {
                    n3 = this.markedBar;
                } else {
                    n2 = this.markedBar;
                }
            }
            for (n = n2; n <= n3; ++n) {
                bufferedImage.setRGB(this.bars[n].position * this.barWidth, this.height - this.bars[n].pixels, this.barWidth, this.bars[n].pixels, this.rgbselected, 0, 1);
            }
        }
        this.repaint();
        this.createToolTip().repaint();
    }

    public List getSelectedLogs() {
        if (this.selectedPosition == -1) {
            return null;
        }
        if (this.markedBar >= 0) {
            int n = this.markedBar < this.selectedPosition ? this.markedBar : this.selectedPosition;
            int n2 = this.markedBar < this.selectedPosition ? this.selectedPosition : this.markedBar;
            int n3 = (n2 + 1) * this.eventsPerBar;
            if (this.logs.size() <= n3) {
                n3 = this.logs.size() - 1;
            }
            return this.logs.subList(n * this.eventsPerBar + 1, n3 + 1);
        }
        return this.bars[this.selectedPosition].logs;
    }

    public List getLogsFromBeginning() {
        if (this.selectedPosition == -1) {
            return null;
        }
        int n = (this.selectedPosition + 1) * this.eventsPerBar;
        if (this.logs.size() <= n) {
            n = this.logs.size() - 1;
        }
        return this.logs.subList(0, n + 1);
    }

    int getMemoryBarIndex(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n / this.barWidth;
        return n2;
    }

    int getMemoryBarIndex(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return -1;
        }
        return this.getMemoryBarIndex(mouseEvent.getX());
    }

    MemoryBar getMemoryBar(MouseEvent mouseEvent) {
        int n = this.getMemoryBarIndex(mouseEvent);
        if (n == -1) {
            return null;
        }
        return this.bars[n];
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        JToolTip jToolTip = this.createToolTip();
        jToolTip.setTipText(this.getToolTipText(mouseEvent));
        return new Point(mouseEvent.getX() - jToolTip.getPreferredSize().width, mouseEvent.getY() - jToolTip.getPreferredSize().height);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        MemoryBar memoryBar = this.getMemoryBar(mouseEvent);
        return "<html>Total memory: " + memoryBar.maximum + "<br>Biggest allocation: " + memoryBar.maxMalloc + "<br>Biggest free: " + memoryBar.maxFree + "</html>";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("ScrollableAllocationGraph action: " + actionEvent);
        if (actionEvent.getActionCommand().equals("setmark")) {
            this.markedBar = this.popupOverBarIndex;
        } else if (actionEvent.getActionCommand().equals("removemark")) {
            this.markedBar = -1;
        }
    }

    class PopupListener
    extends MouseAdapter {
        ScrollableAllocationGraph parent;

        PopupListener(ScrollableAllocationGraph scrollableAllocationGraph2) {
            this.parent = scrollableAllocationGraph2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkForTriggerEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForTriggerEvent(mouseEvent);
        }

        private void checkForTriggerEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.parent.popupOverBarIndex = this.parent.getMemoryBarIndex(mouseEvent.getX());
                this.parent.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class MemoryBar {
        List logs;
        int position;
        int pixels;
        int maximum;
        int maxMalloc;
        int maxFree;

        public MemoryBar(List list, int n, int n2, int n3) {
            this.logs = list;
            this.maximum = n;
            this.position = n2;
            this.pixels = n3;
            this.maxFree = 0;
            this.maxMalloc = 0;
            Iterator iterator = this.logs.iterator();
            while (iterator.hasNext()) {
                MemoryLog memoryLog = (MemoryLog)iterator.next();
                int n4 = memoryLog.getSize();
                if (n4 > this.maxMalloc) {
                    this.maxMalloc = n4;
                    continue;
                }
                if (-n4 <= this.maxFree) continue;
                this.maxFree = -n4;
            }
        }
    }
}

