/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import charm.debug.MemoryPeak;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class MemoryTrace {
    private String filePrefix;
    private int numProcs;
    private int[] numEvents;
    public static final int BEGIN_TRACE = 11;
    public static final int MALLOC = 24;
    public static final int FREE = 25;

    public MemoryTrace(String string, int n) {
        this.filePrefix = string;
        this.numProcs = n;
        this.numEvents = new int[n];
    }

    private String getFilename(int n) {
        return this.filePrefix + n;
    }

    public int findPeaks(int n, int n2, Vector vector) throws IOException {
        String string;
        String string2 = this.getFilename(n);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n5;
            ++n4;
            String[] stringArray = string.split("\\s");
            int n6 = Integer.parseInt(stringArray[0]);
            if (n6 == 11) {
                n5 = Integer.parseInt(stringArray[1]);
                if (n5 > n3) {
                    n6 = 24;
                    n5 -= n3;
                } else {
                    n6 = 25;
                    n5 = n3 - n5;
                }
            } else {
                n5 = Integer.parseInt(stringArray[2]);
            }
            if (n6 == 24) {
                bl = true;
                n3 += n5;
                continue;
            }
            if (n6 == 25) {
                int n7;
                n3 -= n5;
                if (!bl) continue;
                bl = false;
                for (n7 = vector.size(); n7 > 0 && n3 > ((MemoryPeak)vector.elementAt((int)(n7 - 1))).size; --n7) {
                }
                if (n7 >= n2) continue;
                if (vector.size() == n2) {
                    vector.remove(n2 - 1);
                }
                vector.insertElementAt(new MemoryPeak(n4, n3, n), n7);
                continue;
            }
            throw new IOException("Unrecognized Memory Log format");
        }
        return n4;
    }

    public Vector findAllPeaks(int n) throws IOException {
        Vector vector = new Vector(n);
        for (int i = 0; i < this.numProcs; ++i) {
            this.numEvents[i] = this.findPeaks(i, n, vector);
        }
        return vector;
    }

    public Vector readLogs(int n, int n2, int n3) throws IOException {
        Vector<MemoryLog> vector = new Vector<MemoryLog>(n3 - n2 + 2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFilename(n)));
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            n4 += this.getNext(bufferedReader, n4, false).getSize();
        }
        long[] lArray = new long[]{0L};
        vector.add(new MemoryLog(0L, n4, 0, lArray));
        for (int i = n2; i <= n3; ++i) {
            MemoryLog memoryLog = this.getNext(bufferedReader, n4, true);
            vector.add(memoryLog);
            n4 += memoryLog.getSize();
        }
        return vector;
    }

    private MemoryLog getNext(BufferedReader bufferedReader, int n, boolean bl) throws IOException {
        int n2;
        long l;
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\s");
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = 0;
        long[] lArray = null;
        if (n3 == 11) {
            l = 0L;
            n2 = Integer.parseInt(stringArray[1]);
            if (n2 > n) {
                n2 -= n;
                lArray = new long[]{0L};
            } else {
                n2 = n - n2;
            }
        } else {
            block13: {
                try {
                    l = Long.decode(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    l = 0L;
                    if (stringArray[1].equals("(nil)")) break block13;
                    throw numberFormatException;
                }
            }
            if (n3 == 24) {
                n2 = Integer.parseInt(stringArray[2]);
                n4 = Integer.parseInt(stringArray[3]);
                int n5 = n4;
                if (n5 == 0) {
                    n5 = 1;
                }
                lArray = new long[n5];
                lArray[0] = 0L;
                for (int i = 0; i < n4; ++i) {
                    lArray[i] = Long.decode(stringArray[i + 4]);
                }
            } else if (n3 == 25) {
                n2 = -Integer.parseInt(stringArray[2]);
                lArray = new long[]{0L};
            } else {
                throw new IOException("Unrecognized Memory Log format");
            }
        }
        return new MemoryLog(l, n2, n, lArray);
    }

    public static void main(String[] stringArray) throws IOException {
        Vector vector;
        MemoryTrace memoryTrace;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("argv " + i + ": " + stringArray[i]);
        }
        if (stringArray.length < 1) {
            return;
        }
        String string = stringArray[0];
        int n = 10;
        int n2 = 0;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        if (stringArray.length <= 2) {
            memoryTrace = new MemoryTrace(string, n2);
            vector = new Vector(n);
            memoryTrace.findPeaks(0, n, vector);
        } else {
            n2 = Integer.parseInt(stringArray[2]);
            memoryTrace = new MemoryTrace(string, n2);
            vector = memoryTrace.findAllPeaks(n);
        }
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println("Peak #" + (i + 1) + ": " + (MemoryPeak)vector.elementAt(i));
        }
    }
}

