/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import charm.debug.Symbol;
import charm.debug.inspect.Inspector;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class AllocationPoint
implements TreeNode {
    Symbol location;
    int size;
    int count;
    boolean isLeak;
    Vector children;
    AllocationPoint parent;

    public AllocationPoint(AllocationPoint allocationPoint) {
        this.parent = allocationPoint;
        this.count = 0;
        this.size = 0;
        this.isLeak = false;
        this.location = null;
        this.children = null;
    }

    public void readPuppedBuffer(ByteBuffer byteBuffer) {
        long l = Inspector.is64bit() ? byteBuffer.getLong() : (long)byteBuffer.getInt();
        this.location = Symbol.get(l);
        this.size = byteBuffer.getInt();
        this.count = byteBuffer.getInt();
        this.isLeak = byteBuffer.get() > 0;
        int n = byteBuffer.getInt();
        this.children = new Vector(n);
        for (int i = 0; i < n; ++i) {
            AllocationPoint allocationPoint = new AllocationPoint(this);
            this.children.addElement(allocationPoint);
            allocationPoint.readPuppedBuffer(byteBuffer);
        }
    }

    public void addMemoryLog(MemoryLog memoryLog, int n) {
        if (n >= 0) {
            if (this.location == null) {
                this.location = Symbol.get(memoryLog.getStack(n));
            }
            this.size += memoryLog.getSize();
            ++this.count;
        }
        if (memoryLog.getStack().length > n + 1) {
            AllocationPoint allocationPoint = this.getChildWithLocation(memoryLog.getStack(n + 1));
            if (allocationPoint == null) {
                allocationPoint = new AllocationPoint(this);
                if (this.children == null) {
                    this.children = new Vector();
                }
                this.children.add(allocationPoint);
            }
            allocationPoint.addMemoryLog(memoryLog, n + 1);
        }
    }

    public void removeMemoryLog(MemoryLog memoryLog, int n) {
        AllocationPoint allocationPoint;
        int n2 = memoryLog.getSize();
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n >= 0) {
            if (this.location == null) {
                this.location = Symbol.get(memoryLog.getStack(n));
            }
            this.size -= n2;
            --this.count;
        }
        if (memoryLog.getStack().length > n + 1 && (allocationPoint = this.getChildWithLocation(memoryLog.getStack(n + 1))) != null) {
            allocationPoint.removeMemoryLog(memoryLog, n + 1);
            if (allocationPoint.size == 0) {
                this.children.remove(allocationPoint);
            }
        }
    }

    AllocationPoint getChildWithLocation(long l) {
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            AllocationPoint allocationPoint = (AllocationPoint)this.children.elementAt(i);
            if (!allocationPoint.location.equals(l)) continue;
            return allocationPoint;
        }
        return null;
    }

    public String toString() {
        return (this.isLeak ? "* " : "") + this.location + ": size=" + this.size + ", count=" + this.count;
    }

    public Enumeration children() {
        if (this.children == null) {
            return null;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (AllocationPoint)this.children.elementAt(n);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (this.children == null) {
            return -1;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.elementAt(i) != treeNode) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }
}

