/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.AllocationGraphDialog;
import charm.debug.AllocationTreePanel;
import charm.debug.MemoryTrace;
import charm.debug.ScrollableAllocationGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;

public class AllocationGraphPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
ItemListener {
    private JMenuBar menuBar;
    private JMenu menuAction;
    private JCheckBoxMenuItem menuAllocationTree;
    private JCheckBoxMenuItem menuAllocationTreeFromBeginning;
    private JScrollPane displayPane;
    private ScrollableAllocationGraph allocationData;
    private JFrame atFrame;
    private AllocationTreePanel at;
    private boolean traceWrite;

    AllocationGraphPanel() {
        this.setLayout(new BorderLayout());
        this.atFrame = null;
        this.menuBar = new JMenuBar();
        this.menuAction = new JMenu("Allocation Tree");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuAllocationTree = new JCheckBoxMenuItem("Show");
        this.menuAction.add(this.menuAllocationTree);
        this.menuAllocationTree.addItemListener(this);
        this.menuAllocationTreeFromBeginning = new JCheckBoxMenuItem("Start from beginning");
        this.menuAction.add(this.menuAllocationTreeFromBeginning);
        this.menuAllocationTreeFromBeginning.addItemListener(this);
        this.displayPane = new JScrollPane();
        this.add((Component)this.displayPane, "Center");
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void load(JFrame jFrame, MemoryTrace memoryTrace, AllocationGraphDialog allocationGraphDialog) {
        Vector vector;
        this.traceWrite = true;
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (AllocationGraphPanel.this.atFrame != null) {
                    AllocationGraphPanel.this.atFrame.dispose();
                }
            }
        });
        try {
            vector = memoryTrace.readLogs(allocationGraphDialog.getPe(), allocationGraphDialog.getFirstEvent(), allocationGraphDialog.getLastEvent());
        }
        catch (IOException iOException) {
            System.out.println("An error occured while trying to load the memory logs");
            return;
        }
        this.allocationData = new ScrollableAllocationGraph(vector, allocationGraphDialog.getEventsPerBar(), allocationGraphDialog.getBarWidth(), allocationGraphDialog.getHeight());
        this.allocationData.addMouseListener(this);
        this.allocationData.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.allocationData);
        this.displayPane.setViewportView(this.allocationData);
        this.displayPane.setRowHeaderView(this.allocationData.getRowHeader());
        this.displayPane.setCorner("LOWER_LEFT_CORNER", new Corner());
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.menuAllocationTree) {
            if (itemEvent.getStateChange() == 1) {
                if (this.atFrame == null) {
                    this.atFrame = new JFrame("Allocation Tree");
                    this.atFrame.setDefaultCloseOperation(1);
                    this.atFrame.addWindowListener(new AllocationTreeWindowClosed(this));
                    AllocationTreePanel allocationTreePanel = this.at = new AllocationTreePanel();
                    allocationTreePanel.setOpaque(true);
                    this.atFrame.setContentPane(allocationTreePanel);
                    this.atFrame.setTitle("Allocation Tree");
                    List list = this.menuAllocationTreeFromBeginning.isSelected() ? this.allocationData.getLogsFromBeginning() : this.allocationData.getSelectedLogs();
                    this.at.loadMemoryLogs(list, this.menuAllocationTreeFromBeginning.isSelected());
                    this.atFrame.pack();
                }
                this.atFrame.setVisible(true);
                this.menuAllocationTree.setText("Hide");
            } else {
                this.atFrame.setVisible(false);
                this.menuAllocationTree.setText("Show");
            }
        } else if (itemEvent.getItemSelectable() == this.menuAllocationTreeFromBeginning) {
            this.updateAllocationTreeFrame();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.allocationData) {
            this.traceWrite = !this.traceWrite;
            this.updatePosition(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.deletePosition();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.allocationData) {
            this.allocationData.viewX = mouseEvent.getX();
            this.allocationData.viewY = mouseEvent.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updatePosition(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.allocationData) {
            JViewport jViewport = (JViewport)this.allocationData.getParent();
            Point point = jViewport.getViewPosition();
            int n = point.x - (mouseEvent.getX() - this.allocationData.viewX);
            int n2 = point.y - (mouseEvent.getY() - this.allocationData.viewY);
            int n3 = this.allocationData.getWidth() - jViewport.getWidth();
            int n4 = this.allocationData.getHeight() - jViewport.getHeight();
            if (n > n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            jViewport.setViewPosition(new Point(n, n2));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updatePosition(mouseEvent);
    }

    private void updatePosition(MouseEvent mouseEvent) {
        if (this.traceWrite) {
            if (mouseEvent.getSource() == this.allocationData) {
                this.allocationData.selectPosition(mouseEvent);
            } else {
                this.allocationData.selectPosition(null);
            }
            this.updateAllocationTreeFrame();
        }
    }

    private void updateAllocationTreeFrame() {
        if (this.atFrame != null && this.atFrame.isVisible()) {
            List list = this.menuAllocationTreeFromBeginning.isSelected() ? this.allocationData.getLogsFromBeginning() : this.allocationData.getSelectedLogs();
            this.at.loadMemoryLogs(list, this.menuAllocationTreeFromBeginning.isSelected());
        }
    }

    private void deletePosition() {
        if (this.traceWrite) {
            this.allocationData.selectPosition(null);
        }
    }

    class AllocationTreeWindowClosed
    extends WindowAdapter {
        AllocationGraphPanel parent;

        AllocationTreeWindowClosed(AllocationGraphPanel allocationGraphPanel2) {
            this.parent = allocationGraphPanel2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.parent.menuAllocationTree.setSelected(false);
            this.parent.menuAllocationTree.setText("Show");
        }
    }

    class Corner
    extends JComponent {
        Corner() {
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

