/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MainLayout;
import projections.gui.Timeline.MainPanelBackground;
import projections.gui.Timeline.MainPanelForeground;
import projections.gui.Timeline.NullFocusTraversalPolicy;
import projections.gui.Timeline.UserEventObject;

public class MainPanel
extends JPanel
implements Scrollable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    int viewX;
    int viewY;
    Data data;
    MainHandler handler;

    public MainPanel(Data data, MainHandler handler) {
        this.handler = handler;
        this.data = data;
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new NullFocusTraversalPolicy());
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
        this.setLayout(new MainLayout(data));
        this.add(new MainPanelForeground(data));
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.data.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void loadTimelineObjects(boolean useHelperThreads, Component rootWindow) {
        this.setCursor(new Cursor(3));
        this.removeAll();
        this.data.createTLOArray(useHelperThreads, rootWindow);
        this.add(new MainPanelForeground(this.data));
        for (LinkedList objs : this.data.allEntryMethodObjects.values()) {
            for (EntryMethodObject obj : objs) {
                this.add(obj);
                MouseMotionListener[] mml = obj.getMouseMotionListeners();
                boolean found = false;
                int mml_index = 0;
                while (mml_index < mml.length) {
                    if (mml[mml_index] == this) {
                        found = true;
                    }
                    ++mml_index;
                }
                if (found) continue;
                obj.addMouseListener(this);
                obj.addMouseMotionListener(this);
            }
        }
        Iterator<TreeSet<UserEventObject>> iter = this.data.allUserEventObjects.values().iterator();
        while (iter.hasNext()) {
            for (UserEventObject ueo : iter.next()) {
                this.add(ueo);
            }
        }
        MainPanelBackground b = new MainPanelBackground(this.data);
        b.addMouseListener(this);
        b.addMouseMotionListener(this);
        this.add(b);
        this.handler.setData(this.data);
        this.handler.refreshDisplay(true);
        this.setCursor(new Cursor(0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.data.screenHeight());
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.data.singleTimelineHeight();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.data.singleTimelineHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Data getData() {
        return this.data;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.viewX);
            int newY = p.y - (e.getY() - this.viewY);
            int maxX = this.getWidth() - jv.getWidth();
            int maxY = this.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
        this.data.displayMustBeRepainted();
    }

    public void mousePressed(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.viewX = e.getX();
            this.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

