/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.preference;

import charm.debug.preference.Recent;
import charm.util.ReflectiveXML;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.xml.sax.SAXException;

public class Preference
extends JPanel {
    public Dimension size = null;
    public Point location = null;
    public Recent recentConfig = new Recent();
    public Recent recentPython = new Recent();

    public Object[] getRecent() {
        return this.recentConfig.getList();
    }

    public void addRecent(String file) {
        this.recentConfig.add(file);
    }

    public Object[] getRecentPython() {
        if (this.recentPython == null) {
            this.recentPython = new Recent();
        }
        return this.recentPython.getList();
    }

    public void addRecentPython(String str) {
        if (this.recentPython == null) {
            this.recentPython = new Recent();
        }
        this.recentPython.add(str);
    }

    public static Preference load() {
        FileReader in;
        try {
            in = new FileReader(System.getProperty("user.home") + "/.cpdrc");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        System.out.println("Loading preference file " + System.getProperty("user.home") + "/.cpdrc");
        try {
            Preference pref = (Preference)ReflectiveXML.read(in);
            in.close();
            return pref;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not load configuration file.\nPlease delete the file '.cpdrc' from your home directory.", "Failed to load configuration", 0);
            return null;
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(null, "Could not load configuration file.\nPlease delete the file '.cpdrc' from your home directory.", "Failed to load configuration", 0);
            return null;
        }
    }

    public void save() {
        try {
            FileWriter out = new FileWriter(System.getProperty("user.home") + "/.cpdrc");
            ReflectiveXML.write(out, this);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Failed to save configuration file");
        }
    }
}

