/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Vector3d {
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d) {
        this.y = this.z = d;
        this.x = this.z;
    }

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public final void copyFrom(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public final double magSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.magSqr());
    }

    public final Vector3d normalize() {
        return this.scaleBy(1.0 / this.magnitude());
    }

    public final Vector3d plus(Vector3d vector3d) {
        return new Vector3d(this.x + vector3d.x, this.y + vector3d.y, this.z + vector3d.z);
    }

    public final Vector3d minus(Vector3d vector3d) {
        return new Vector3d(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public final Vector3d scaleBy(double d) {
        return new Vector3d(d * this.x, d * this.y, d * this.z);
    }

    public final double dot(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public final Vector3d cross(Vector3d vector3d) {
        return new Vector3d(this.y * vector3d.z - this.z * vector3d.y, this.z * vector3d.x - this.x * vector3d.z, this.x * vector3d.y - this.y * vector3d.x);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public static Vector3d read(DataInputStream dataInputStream) throws IOException {
        Vector3d vector3d = new Vector3d();
        vector3d.x = dataInputStream.readDouble();
        vector3d.y = dataInputStream.readDouble();
        vector3d.z = dataInputStream.readDouble();
        return vector3d;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeDouble(this.x);
        dataOutputStream.writeDouble(this.y);
        dataOutputStream.writeDouble(this.z);
    }
}

