/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.event.MouseEvent;
import projections.gui.Clickable;
import projections.gui.PopUpAble;
import projections.gui.ResponsiveToMouse;
import projections.gui.graph.DataSource;

public class DataSource2D
extends DataSource {
    private String title;
    private double[][] data;
    private int xValues;
    private ResponsiveToMouse parent;

    public DataSource2D(String title_, double[][] data_) {
        this.title = title_;
        this.data = data_;
        this.xValues = this.data.length;
        this.parent = null;
    }

    public DataSource2D(String title_, double[][] data_, ResponsiveToMouse parent_) {
        this.title = title_;
        this.data = data_;
        this.parent = parent_;
        this.xValues = this.data.length;
    }

    public DataSource2D(String title_, int[][] data_) {
        this.title = title_;
        this.data = this.intToDouble(data_);
        this.xValues = this.data.length;
        this.parent = null;
    }

    public DataSource2D(String title_, int[][] data_, ResponsiveToMouse parent_) {
        this.title = title_;
        this.data = this.intToDouble(data_);
        this.parent = parent_;
        this.xValues = this.data.length;
    }

    public String[] getPopup(int xVal, int yVal) {
        int NUM_EXTRA_LINES = 4;
        if (this.parent != null && this.parent instanceof PopUpAble) {
            String[] tempText = ((PopUpAble)this.parent).getPopup(xVal, yVal);
            int offset = tempText.length;
            int longestLength = 0;
            String[] text = new String[offset + NUM_EXTRA_LINES];
            if (offset == 0) {
                return tempText;
            }
            int i = 0;
            while (i < offset) {
                if (tempText[i].length() > longestLength) {
                    longestLength = tempText[i].length();
                }
                text[i] = tempText[i];
                ++i;
            }
            text[offset] = new String();
            i = 0;
            while (i < longestLength) {
                int n = offset;
                text[n] = String.valueOf(text[n]) + "-";
                ++i;
            }
            int count = 0;
            double total = 0.0;
            int i2 = 0;
            while (i2 < this.data[xVal].length) {
                if (this.data[xVal][i2] > 0.0) {
                    ++count;
                    total += this.data[xVal][i2];
                }
                ++i2;
            }
            text[offset + 1] = "Number: " + count;
            text[offset + 2] = count > 0 ? "Average: " + total / (double)count : "No Average";
            text[offset + 3] = "Total: " + total;
            return text;
        }
        return null;
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (this.parent != null && this.parent instanceof Clickable) {
            ((Clickable)this.parent).toolClickResponse(e, xVal, yVal);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getIndexCount() {
        return this.xValues;
    }

    public int getValueCount() {
        return this.data[0].length;
    }

    public void getValues(int index, double[] values) {
        int j = 0;
        while (j < this.data[index].length) {
            values[j] = this.data[index][j];
            ++j;
        }
    }

    private double[][] intToDouble(int[][] data) {
        double[][] retVal = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            retVal[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                retVal[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
        return retVal;
    }
}

