/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import projections.gui.BItem;
import projections.gui.GraphControlPanel;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.GraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ZItem;

public class GraphData {
    int myRun = 0;
    static final int PROCESSOR = 0;
    static final int INTERVAL = 1;
    static final int TIME = 10;
    static final int MSGS = 11;
    static final int BOTH = 12;
    static final int LINE = 20;
    static final int BAR = 21;
    protected int intervalStart;
    protected int intervalEnd;
    protected int numEntries;
    protected int graphtype;
    protected int xmode;
    protected int ymode;
    protected int minx;
    protected int maxx;
    protected int offset;
    protected int offset2;
    protected int offset3;
    protected float scale;
    protected double yscale;
    protected double wscale;
    protected double xscale;
    private float colorvalue;
    protected ZItem[] systemUsage;
    protected ZItem[][] systemMsgs;
    protected ZItem[][] userEntry;
    protected ZItem[] onGraph;
    protected BItem processor;
    protected BItem interval;
    protected GraphControlPanel controlPanel;
    protected GraphLegendPanel legendPanel;
    protected GraphDisplayPanel displayPanel;
    protected GraphWindow graphWindow;
    protected OrderedIntList origProcList;

    public GraphData(long intsize, int NintervalStart, int NintervalEnd, OrderedIntList procList) {
        int t;
        this.intervalStart = NintervalStart;
        this.intervalEnd = NintervalEnd;
        int numIs = this.intervalEnd - this.intervalStart + 1;
        this.yscale = 1.0;
        this.wscale = 1.0;
        this.offset = 10;
        this.offset2 = 0;
        this.offset3 = 0;
        this.numEntries = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.colorvalue = 0.0f;
        this.graphtype = 21;
        this.xmode = 1;
        this.ymode = 11;
        this.processor = new BItem();
        this.origProcList = procList;
        this.processor.list = procList;
        this.processor.string = this.processor.list.listToString();
        this.processor.num = procList.size();
        String[] s1 = new String[]{"Queue Size", "Processor Usage(%)", "Idle Time(%)"};
        this.systemUsage = new ZItem[3];
        int a = 0;
        while (a < 3) {
            this.systemUsage[a] = new ZItem();
            this.systemUsage[a].name = s1[a];
            this.systemUsage[a].exists = MainWindow.runObject[this.myRun].getSystemUsageData(a) != null;
            float gray = (float)(1.0 - (double)a * 0.3);
            this.systemUsage[a].color = new Color(gray, gray, gray);
            if (a == 1) {
                this.systemUsage[a].state = true;
            }
            if (a == 0) {
                this.systemUsage[a].type = "Msgs";
                this.systemUsage[a].ymode = 11;
            } else {
                this.systemUsage[a].type = "%";
                this.systemUsage[a].ymode = 12;
            }
            ++a;
        }
        this.onGraph = new ZItem[1];
        this.onGraph[0] = this.systemUsage[1];
        String[] s2 = new String[]{"New Chare", "For Chare", "New Group", "Load Balancing", "Quiescence"};
        String[] s3 = new String[]{"Creation", "Processing", "Time"};
        this.systemMsgs = new ZItem[5][3];
        int a2 = 0;
        while (a2 < 5) {
            t = 0;
            while (t < 3) {
                this.systemMsgs[a2][t] = new ZItem();
                this.systemMsgs[a2][t].name = s2[a2];
                this.systemMsgs[a2][t].type = s3[t];
                this.systemMsgs[a2][t].exists = MainWindow.runObject[this.myRun].hasSystemMsgsData(a2, t);
                if (t == 0) {
                    this.systemMsgs[a2][t].color = this.nextColor();
                    this.systemMsgs[a2][t].ymode = 11;
                } else if (t == 1) {
                    this.systemMsgs[a2][t].color = this.systemMsgs[a2][0].color.darker();
                    this.systemMsgs[a2][t].ymode = 11;
                } else if (t == 2) {
                    this.systemMsgs[a2][t].color = this.systemMsgs[a2][0].color;
                    this.systemMsgs[a2][t].ymode = 10;
                }
                ++t;
            }
            ++a2;
        }
        this.userEntry = new ZItem[this.numEntries][3];
        a2 = 0;
        while (a2 < this.numEntries) {
            t = 0;
            while (t < 3) {
                this.userEntry[a2][t] = new ZItem();
                this.userEntry[a2][t].name = MainWindow.runObject[this.myRun].getEntryNameByIndex(a2);
                this.userEntry[a2][t].type = s3[t];
                this.userEntry[a2][t].parent = MainWindow.runObject[this.myRun].getEntryChareNameByIndex(a2);
                this.userEntry[a2][t].exists = MainWindow.runObject[this.myRun].hasUserEntryData(a2, t);
                if (t == 0) {
                    this.userEntry[a2][t].color = this.nextColor();
                    this.userEntry[a2][t].ymode = 11;
                } else if (t == 1) {
                    this.userEntry[a2][t].color = this.userEntry[a2][0].color.darker();
                    this.userEntry[a2][t].ymode = 11;
                } else if (t == 2) {
                    this.userEntry[a2][t].color = this.userEntry[a2][0].color;
                    this.userEntry[a2][t].ymode = 10;
                }
                ++t;
            }
            ++a2;
        }
        this.initData(numIs, intsize);
    }

    public void initData(int numIs, long intsize) {
        int t;
        this.scale = 1.0f;
        this.interval = new BItem();
        this.interval.num = numIs;
        this.interval.size = intsize;
        this.interval.list = new OrderedIntList();
        int i = this.intervalStart;
        while (i <= this.intervalEnd) {
            this.interval.list.insert(i);
            ++i;
        }
        this.interval.string = this.interval.list.listToString();
        int numProcessors = this.origProcList.size();
        int a = 0;
        while (a < 3) {
            if (MainWindow.runObject[this.myRun].getSystemUsageData(a) != null) {
                this.systemUsage[a].data = MainWindow.runObject[this.myRun].getSystemUsageData(a);
                this.systemUsage[a].curPData = new int[numProcessors];
                this.systemUsage[a].curIData = new int[this.interval.num];
            }
            ++a;
        }
        a = 0;
        while (a < 5) {
            t = 0;
            while (t < 3) {
                if (MainWindow.runObject[this.myRun].hasSystemMsgsData(a, t)) {
                    this.systemMsgs[a][t].data = MainWindow.runObject[this.myRun].getSystemMsgsData(a, t);
                    this.systemMsgs[a][t].curPData = new int[numProcessors];
                    this.systemMsgs[a][t].curIData = new int[this.interval.num];
                }
                ++t;
            }
            ++a;
        }
        a = 0;
        while (a < this.numEntries) {
            t = 0;
            while (t < 3) {
                if (MainWindow.runObject[this.myRun].hasUserEntryData(a, t)) {
                    this.userEntry[a][t].data = MainWindow.runObject[this.myRun].getUserEntryData(a, t);
                    this.userEntry[a][t].curPData = new int[numProcessors];
                    this.userEntry[a][t].curIData = new int[this.interval.num];
                }
                ++t;
            }
            ++a;
        }
        this.setData();
    }

    private Color nextColor() {
        Color tmp = Color.getHSBColor((float)((double)this.colorvalue * 0.173 % 1.0), (float)(1.0 - 0.6 * ((double)this.colorvalue * 0.729 % 1.0)), 1.0f);
        this.colorvalue = (float)((double)this.colorvalue + 1.0);
        return tmp;
    }

    private int setCurIData(ZItem item) {
        int max = 0;
        int i = this.intervalStart;
        while (i <= this.intervalEnd) {
            item.curIData[i - this.intervalStart] = 0;
            if (this.interval.list.contains(i)) {
                int element;
                int count = 0;
                this.processor.list.reset();
                int peIdx = 0;
                while ((element = this.processor.list.nextElement()) >= 0) {
                    if (item.data[peIdx] == null) continue;
                    int n = i - this.intervalStart;
                    item.curIData[n] = item.curIData[n] + item.data[peIdx][i - this.intervalStart];
                    ++count;
                    ++peIdx;
                }
                if (item.ymode == 12) {
                    if (count != 0) {
                        int n = i - this.intervalStart;
                        item.curIData[n] = item.curIData[n] / count;
                    }
                } else {
                    max = Math.max(item.curIData[i - this.intervalStart], max);
                }
            }
            ++i;
        }
        return max;
    }

    private int setCurPData(ZItem item) {
        int max = 0;
        int numProcessors = this.processor.list.size();
        int p = 0;
        while (p < numProcessors) {
            item.curPData[p] = 0;
            if (item.data[p] != null) {
                int element;
                int count = 0;
                this.interval.list.reset();
                while ((element = this.interval.list.nextElement()) >= 0) {
                    int n = p;
                    item.curPData[n] = item.curPData[n] + item.data[p][element - this.intervalStart];
                    ++count;
                }
                if (item.ymode == 12) {
                    int n = p;
                    item.curPData[n] = item.curPData[n] / count;
                } else {
                    max = Math.max(item.curPData[p], max);
                }
            }
            ++p;
        }
        return max;
    }

    public void setData() {
        int maxMP = 0;
        int maxTP = 0;
        int maxMI = 0;
        int maxTI = 0;
        int a = 0;
        while (a < this.onGraph.length) {
            if (this.onGraph[a] == null) {
                System.out.println("onGraph[" + a + "/" + this.onGraph.length + "]==null");
            } else if (this.onGraph[a].ymode == 12) {
                this.setCurPData(this.onGraph[a]);
                this.setCurIData(this.onGraph[a]);
            } else if (this.onGraph[a].ymode == 10) {
                maxTP = Math.max(this.setCurPData(this.onGraph[a]), maxTP);
                maxTI = Math.max(this.setCurIData(this.onGraph[a]), maxTI);
            } else {
                maxMP = Math.max(this.setCurPData(this.onGraph[a]), maxMP);
                maxMI = Math.max(this.setCurIData(this.onGraph[a]), maxMI);
            }
            ++a;
        }
        this.processor.maxTime = maxTP;
        this.processor.maxMsgs = maxMP;
        this.interval.maxTime = maxTI;
        this.interval.maxMsgs = maxMI;
    }
}

