/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import projections.gui.FormattedNumber;
import projections.gui.count.TableSorter;

public class EntryPointWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultTableCellRenderer rightJustify_ = new DefaultTableCellRenderer();
    private TableSorter sorter = null;
    private JTable jTable = null;
    private EPTable epTable;
    private DecimalFormat format = null;
    private final JFileChooser fileChooser;
    Color BACKGROUND = Color.black;
    private Color FOREGROUND = Color.white;
    private int currRow = 0;
    private int numRows = 100;
    int numCols = 5;
    RowData[] data = new RowData[this.numRows];

    private void growTable() {
        this.numRows *= 2;
        RowData[] temp = new RowData[this.numRows];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new RowData();
            ++i;
        }
        i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.numCols) {
                temp[i].value[j] = this.data[i].value[j];
                temp[i].color = this.data[i].color;
                ++j;
            }
            ++i;
        }
        this.data = temp;
    }

    public void actionPerformed(ActionEvent ae) {
        int returnVal = this.fileChooser.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                this.fileChooser.approveSelection();
                FileWriter outputFile = new FileWriter(this.fileChooser.getSelectedFile());
                int i = 0;
                while (i < this.currRow) {
                    int j = 0;
                    while (j < this.numCols) {
                        outputFile.write(String.valueOf(this.sorter.getValueAt(i, j).toString()) + "\t");
                        ++j;
                    }
                    outputFile.write("\n");
                    ++i;
                }
                outputFile.close();
                JOptionPane.showMessageDialog(this, "File Saved", "Information", 1);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            JOptionPane.showMessageDialog(this, "Error While Saving File" + e, "Error", 0);
        }
    }

    public EntryPointWindow() {
        super("Longest EntryPoints");
        if (this.format == null) {
            this.format = new DecimalFormat();
            this.format.setGroupingUsed(true);
        }
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(this);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = new RowData();
            ++i;
        }
        this.fileChooser = new JFileChooser();
        this.epTable = new EPTable();
        this.sorter = new TableSorter(this.epTable);
        this.jTable = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable);
        this.jTable.setColumnSelectionAllowed(false);
        this.jTable.setBackground(this.BACKGROUND);
        this.jTable.setForeground(this.FOREGROUND);
        TableColumn column = null;
        column = this.jTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.jTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        column.setCellRenderer(new NameRenderer());
        int j = 2;
        while (j < this.epTable.getColumnCount()) {
            column = this.jTable.getColumnModel().getColumn(j);
            column.setPreferredWidth(75);
            column.setCellRenderer(this.rightJustify_);
            ++j;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.jTable), "Center");
        this.getContentPane().add((Component)saveButton, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EntryPointWindow.this.setVisible(false);
            }
        });
    }

    public void clearTableData() {
        this.data = new RowData[this.numRows];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = new RowData();
            ++i;
        }
        this.currRow = 0;
        this.sorter.tableChanged(new TableModelEvent(this.epTable, 0, this.epTable.getRowCount() - 1, -1));
    }

    public void writeToTable(int pe, String epName, long startTime, long endTime, Color color) {
        if (this.currRow == this.numRows) {
            this.growTable();
        }
        this.data[this.currRow].value[0] = new Integer(pe);
        this.data[this.currRow].value[1] = epName;
        this.data[this.currRow].value[2] = new FormattedNumber(startTime, this.format);
        this.data[this.currRow].value[3] = new FormattedNumber(endTime, this.format);
        this.data[this.currRow].value[4] = new FormattedNumber(endTime - startTime, this.format);
        this.data[this.currRow].color = color;
        ++this.currRow;
        this.sorter.tableChanged(new TableModelEvent(this.epTable, 0, this.epTable.getRowCount() - 1, -1));
    }

    private class EPTable
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        public int getColumnCount() {
            return EntryPointWindow.this.numCols;
        }

        public int getRowCount() {
            if (EntryPointWindow.this.data != null) {
                return EntryPointWindow.this.data.length;
            }
            return 0;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Processor Number";
                }
                case 1: {
                    return "EntryPoint Name";
                }
                case 2: {
                    return "Begin Time";
                }
                case 3: {
                    return "End Time";
                }
                case 4: {
                    return "Delta Time";
                }
            }
            return "ERROR";
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return String.class;
            }
            return FormattedNumber.class;
        }

        public Object getValueAt(int row, int col) {
            return EntryPointWindow.this.data[row].value[col];
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setEnabled(table == null || table.isEnabled());
            if (EntryPointWindow.this.data != null && EntryPointWindow.this.data[row] != null) {
                this.setForeground(EntryPointWindow.this.data[row].color);
            }
            this.setBackground(EntryPointWindow.this.BACKGROUND);
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }

    private class RowData {
        Object[] value;
        Color color;

        public RowData() {
            this.value = new Object[EntryPointWindow.this.numCols];
        }
    }
}

