#include "TCsim_sim.h"
extern int numWth;
extern int netLength;
extern int netHeight;
extern int netWidth;

// Switch implementation
Switch::Switch() {}

// the non-empty constructor (empty constructors do nothing)
Switch::Switch (SwitchInit *m)
{
  id = m->id;
  curLabel = Label(0, id.id);
  //assign neighbors to channel
  //build the cubecoord array we use locally to determine neighbors
  CProxy_routeMap nodemap_proxy(m->groupID);
  groupID=m->groupID;
  nodemap=nodemap_proxy.ckLocalBranch();
  int ***cubecoords = (int***)malloc(m->netLength*sizeof(int**));
  for (unsigned int z=0; z<m->netLength; z++)
    cubecoords[z] = (int**)malloc(m->netHeight*sizeof(int*));
  for (unsigned int x=0; x<m->netLength; x++)
    for (unsigned int y=0; y<m->netHeight; y++)
      cubecoords[x][y] = (int*)malloc(m->netWidth*sizeof(int));
  for (unsigned int l=0;l<m->netLength;l++)
    for(unsigned int h=0;h<m->netHeight;h++)
      for(unsigned int w=0;w<m->netWidth;w++)
	cubecoords[l][h][w]=m->idstart+l*m->netHeight*m->netWidth+h*m->netWidth+w;
  int    i=0;
  Chanlock locks[6];
  
  for(i=0;i<6;i++) {
    Label lockl=GetLabel();
    locks[i]=Chanlock(lockl);
  }
  i=0;
  if((unsigned int) m->position.x==m->netLength-1)  // we're wrapping to x=0
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[0][m->position.y][m->position.z],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x+1][m->position.y][m->position.z],0),m->bandwidth,locks[i],1);
  i++;
  if(m->position.x==0)  // we're wrapping to x=netLength
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[m->netLength-1][m->position.y][m->position.z],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x-1][m->position.y][m->position.z],0),m->bandwidth,locks[i],1);
  i++;
  if((unsigned int)m->position.y==m->netHeight-1)  // we're wrapping to y=0
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[m->position.x][0][m->position.z],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y+1][m->position.z],0),m->bandwidth,locks[i],1);
  i++;
  if(m->position.y==0)  // we're wrapping to y=netHeight
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[m->position.x][m->netHeight-1][m->position.z],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y-1][m->position.z],0),m->bandwidth,locks[i],1);
  i++;
  if((unsigned int) m->position.z==m->netWidth-1)  // we're wrapping to z=0
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y][0],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y][m->position.z+1],0),m->bandwidth,locks[i],1);
  i++;
  if(m->position.z==0)  // we're wrapping to z=netWidth
    {
      if(network_model == MESH3D) //not torus lock this edge
	locks[i].testAndSet(id);
      channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y][m->netWidth-1],0),m->bandwidth,locks[i],m->wrapcost);
    }
  else
    channels[i]=Channel(id,Label(cubecoords[m->position.x][m->position.y][m->position.z-1],0),m->bandwidth,locks[i],1);
  // to initialize queues their zero state is good enough do nothing
  lastChannel = 0;
  delete (m);
/*
  for (i=0; i<6; i++)
    channels[i].dump();
*/
}

// event handling

// Entry point for messages into the network
void Switch::initiate(DataMesgEnv *m)
{ // Push_back the message into our outbound queue then try to send the
  // message (make the netconnection, once that succeeds transmission
  // will begin automatically)
  if (m->bag.dest == id)
    CkAbort("ERROR: Don't place local messages on the network!\n");
  // reset the label
  m->bag.mid = GetLabel();
  m->bag.mesg.id = m->bag.mid;
  outMesgQ.push_back(m->bag);
#ifdef MDEBUG
  char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s OMQ +1 to %d\n",id.sndump(mdbout,79),outMesgQ.size());

#endif
  //m->dump();
  netconnect(m->bag.mid);
}


//called at end of program
void Switch::terminus()
{
#ifdef TERMDEBUG
  qdump();
#endif
}

// The method by which other nodes communicate with us for channel chanlocks
// and otherwise open data transfers
// does not consume bandwidth. 
// sender lock the channel
void Switch::recv(Command *m)
{
  cmdOperation thisop = m->bag.command.cmdop;
  bool success = false;
  if ((m->bag.dest == id)&& (thisop == chanlock)) {
    DataMesg expect(m->bag.command.mid, m->bag.packsize, m->bag.numDataPackets, m->bag.td);

    inMesgQ.push_back (expect);
#ifdef MDEBUG
  char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s IMQ +1 to %d\n",id.sndump(mdbout,79),inMesgQ.size());
#endif

    success=true;
  }
  else if (thisop == chanlock) {
    int dchannel;
    map < Label, OutnBack >::iterator miter=packetroute.find(m->bag.command.mid);
    // already has a route starting from this switch, have a loop back
    if((miter!=packetroute.end()) && (miter->first ==m->bag.command.mid)) {
      success=false;
    }
    else {
      dchannel = findTheChannel(m->bag.dest,m->bag.sender);
      if(dchannel<6) {
	success = channels[dchannel].chanlock.testAndSet (m->bag.command.mid);
      }
    }
    if(success) {
      // add route to packetroute
      //	  pair < Label, OutnBack > melem;
      //	  melem.first=m->bag.command.mid;
      //	  OutnBack back(dchannel,m->bag.sender.idAsInt());
      // melem.second=back;
      packetroute.insert(map < Label, OutnBack>::value_type(Label(m->bag.command.mid),OutnBack(dchannel,m->bag.sender)));
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s prt +1 to %d\n",id.sndump(mdbout,79),packetroute.size());
#endif

      //CkPrintf("Switch %s, added route to %d for mid %s at time %d\n", id.sdump(),channels[dchannel].dest.idAsInt(),m->bag.command.mid.sdump(),m->timestamp);
      Command *passcommand =new Command (m->bag);
      passcommand->bag.sender=id;
      POSE_invoke (recv (passcommand), Switch, channels[dchannel].dest.idAsInt(), channels[dchannel].cost);
    }
  }
  else {
    char sout[80];
    memset(sout,0,80);
    parent->CommitError("ERROR Switch %s unchanlock or unknown",id.sndump(sout,79));
    parent->CommitError(" command id %s %d\n",m->bag.id.sndump(sout,79),m->timestamp);
    CmiAbort("");
  }
  if(!(success) || (m->bag.dest == id)) {
    // we need to generate our own reply here and now rather than pass along 
    //a reply later
    // it may be possible that this reply is sent to itself
    //               reply,src, dest,        intermed, from,   mid,     cid,done
    ReplyBag newbag(success,id,m->bag.src,m->bag.sender,id,m->bag.command.mid,m->bag.id,false);
    Reply *myreply = new Reply (newbag);
    if((success) && (m->bag.dest == id))

      replyQ.push_back(newbag); // we'll want this later to send the done reply
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s RQ +1 to %d\n",id.sndump(mdbout,79),replyQ.size());
#endif
    POSE_invoke (recv (myreply), Switch, m->bag.sender.idAsInt(), getcost(m->bag.sender));
  }
}


// The method by which other nodes reply to commands or error conditions
//* does not consume bandwidth. 
void Switch::recv(Reply *m)
{
/*
  ???? gzheng
  map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
  if ((miter!=packetroute.end()) && (miter->first==m->bag.mid)) {
    // see if reply come from the packroute channel expected
    if (m->bag.from.id != channels[miter->second.first].dest.id)  {
      parent->CommitError("ERROR: [%d] Reply not valid from:%s channel dest:%s\n", id.id, m->bag.from.sdump(), channels[miter->second.first].dest.sdump());
      return;
    }
  }
  else {	// not found a packet route
    if (m->bag.intermed != m->bag.from)  {
      parent->CommitError("ERROR: [%d]  no packetroute for msg [%s].\n", id.id, m->bag.mid.sdump());
      return;
    }
  }
*/

  if(m->bag.dest == id) { // this reply is for us
    //CkPrintf("Switch %s got reply %d for command %s mid %s at time %d\n", id.sdump(), m->bag.reply,m->bag.cid.sdump(), m->bag.mid.sdump(),m->timestamp);

    if(m->bag.done) { // we're done with the message
      map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
      if ((miter!=packetroute.end()) && (miter->first==m->bag.mid)) {
        if (m->bag.from.id != channels[miter->second.first].dest.id)  {
	  char sout[80];
	  memset(sout,0,80);
          parent->CommitError("ERROR: [%d] Reply not valid from:%s", id.id, m->bag.from.sndump(sout,79));
          parent->CommitError(" channel dest:%s\n", channels[miter->second.first].dest.sndump(sout,79));
          return;
        }
        channels[miter->second.first].chanlock.unchanlock(m->bag.mid);
        packetroute.erase(m->bag.mid);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s prt -1 to %d\n",id.sndump(mdbout,79),packetroute.size());
#endif

        channelAvailable();
      }

      DataMesgEnvBag mymesg(m->bag.mid);
      deque <DataMesgEnvBag>::iterator msgiter=find(outMesgQ.begin(),
						    outMesgQ.end(), mymesg);
      if ((msgiter!=outMesgQ.end())&&(mymesg.mid==msgiter->mid))
	{
	  outMesgQ.erase(msgiter); 
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s OMQ -1 to %d\n",id.sndump(mdbout,79),outMesgQ.size());
#endif
	}
    }
    else if (!m->bag.cid.isnull()) { // is a reply to a command
      // BEGIN IF
      CommandBag mycommand(m->bag.cid);
      deque <CommandBag>::iterator cmditer=find(cmdMesgQ.begin(),
						cmdMesgQ.end(), mycommand);
      if (cmditer==cmdMesgQ.end()) {
	char sout[80];
	memset(sout,0,80);
        parent->CommitError("ERROR: [%d] No such command [%s] for msg:%d in recovery:%d.\n", id.id, m->bag.cid.sndump(sout,79), m->bag.mid.id, CpvAccess(stateRecovery));
	// probably ripped out during loop avoidance
	/*   ???????? gzheng
	     map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
	     if ((miter!=packetroute.end()) && (miter->first==m->bag.mid)) {
	     channels[miter->second.first].chanlock.unchanlock(m->bag.mid);
	     packetroute.erase(m->bag.mid);
	     }
	*/
      }
      else if (m->bag.reply) {
	char sout[80];
	memset(sout,0,80);
	if (cmditer->command.cmdop == chanlock) { // send the message
          map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
	  if (m->bag.from.id != channels[miter->second.first].dest.id)  {
            parent->CommitError("ERROR: [%d] Reply not valid from:%s", id.id, m->bag.from.sndump(sout,79));
            parent->CommitError(" channel dest:%s\n", channels[miter->second.first].dest.sndump(sout,79));
            return;
          }
	  if (!sendMesg(m->bag.mid))
	    {	    

	      parent->CommitError("ERROR sendMesg failed cmd%s",m->bag.cid.sndump(sout,79));
	      parent->CommitError(" mesg%s time%d\n", m->bag.mid.sndump(sout,79));
	    }
	}
	else {
	  parent->CommitError("ERROR: Our %s command [%s] was\n", id.sndump(sout,79));
	  parent->CommitError(" %s not chanlock\n", m->bag.cid.sndump(sout,79), cmditer->command.cmdop);
	}
	cmdMesgQ.erase(cmditer);  // we're done with this command
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s CMQ -1 to %d\n",id.sndump(mdbout,79),cmdMesgQ.size());
#endif

      }
      else { // our command failed try again
	if (cmditer->command.cmdop==chanlock) {
          map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
          if ((miter!=packetroute.end()) && (miter->first==m->bag.mid)) {
	    channels[miter->second.first].chanlock.unchanlock(m->bag.mid);
	    packetroute.erase(m->bag.mid);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s prt -1 to %d\n",id.sndump(mdbout,79),packetroute.size());
#endif

          }
	  cmdMesgQ.erase(cmditer);  //we're done with this command
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s CMQ -1 to %d\n",id.sndump(mdbout,79),cmdMesgQ.size());
#endif

	  netconnect(m->bag.mid);
          //channelAvailable();		// ??
	}
	else {
	    char sout[80];
	    memset(sout,0,80);
	  // if chanrecvdata fails it means the netconnection broke and we 
	  // have to rebuild the netconnection and resend failed packets
	  // first cut implementation assumes netconnections can't break
	  parent->CommitError("ERROR: [%s] unknown command type command [%s] was", id.sndump(sout,79));
	  parent->CommitError(" [%s] was %d not chanlock\n", m->bag.cid.sndump(sout,79), (int)cmditer->command.cmdop);
	  cmdMesgQ.erase(cmditer);  // we're done with this command
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s CMQ -1 to %d\n",id.sndump(mdbout,79),cmdMesgQ.size());
#endif

	}
      }
      // END IF
    }
    else { // a chanrecvdata they can't fail so do nothing
      char sout[80];
      memset(sout,0,80);
      parent->CommitError("ERROR: [%s] Reply wasn't to a command at all\n",
			  id.sndump(sout,79));
    }
  }
  else {  	// not for us, forwarding
    map < Label, OutnBack >::const_iterator miter=packetroute.find(m->bag.mid);
    if ((miter!=packetroute.end()) && (miter->first==m->bag.mid)) {
      Label back=miter->second.second;
      if ((! m->bag.reply)||(m->bag.done)) { //unchanlock before forwarding
	channels[packetroute[m->bag.mid].first].chanlock.unchanlock(m->bag.mid);
	packetroute.erase(m->bag.mid);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s prt -1 to %d\n",id.sndump(mdbout,79),packetroute.size());
#endif

      }
      //              reply,   src, dest,       intermed,     mid,    cid,done
      ReplyBag newbag(m->bag.reply, m->bag.src, m->bag.dest, back, id, m->bag.mid,
		      m->bag.cid,m->bag.done);
      Reply *myreply = new Reply (newbag);
      POSE_invoke(recv(myreply), Switch, back.idAsInt(), getcost(Label(back)));
      // CmiPrintf("[forward reply: status:%d src:%s dest:%s intermed:%s cid:%s]\n", m->bag.reply, m->bag.src.sdump(), m->bag.dest.sdump(), back.sdump(), m->bag.cid.sdump());
      // forward
    }
    else {
      char sout[80];
      memset(sout,0,80);
      parent->CommitError("ERROR: [%d]  no packetroute for msg [%s].\n", id.id, m->bag.mid.sndump(sout,79));

    }
  }
}

//this is mostly a copy of the recv (command) entry method
//PRE:we know the channel is available
//handle the command
void Switch::lockAndSend(int dchannel, Command *cmd)
{
  bool success=false;
  map < Label, OutnBack >::iterator miter=packetroute.find(cmd->bag.command.mid);
  char sout[80];
  memset(sout,0,80);

  // already has a route starting from this switch, have a loop back
  if((miter!=packetroute.end()) && (miter->first ==cmd->bag.command.mid)) {
    success=false;
  }
  else {
    if(dchannel<6) {
      success = channels[dchannel].chanlock.testAndSet (cmd->bag.command.mid);
    }
    else
      {

	parent->CommitError("ERROR: Switch %s got insane channel %d",id.sndump(sout,79),dchannel);
	parent->CommitError(" %s which should be free \n",cmd->bag.command.mid.sndump(sout,79));

	CmiAbort ("");
      }
    if(! success)
      {
	parent->CommitError("ERROR: Switch %s cannot lock channel %d",id.sndump(sout,79),dchannel);
	parent->CommitError(" %s which should be free \n",cmd->bag.command.mid.sndump(sout,79));

      }
  }
  if(success) {
    // add route to packetroute
    //	  pair < Label, OutnBack > melem;
    //	  melem.first=cmd->bag.command.mid;
    //	  OutnBack back(dchannel,cmd->bag.sender.idAsInt());
    // melem.second=back;
    packetroute.insert(map < Label, OutnBack>::value_type(Label(cmd->bag.command.mid),OutnBack(dchannel,cmd->bag.sender)));
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s prt +1 to %d\n",id.sndump(mdbout,79),packetroute.size());
#endif

    Command *passcommand =new Command (cmd->bag);
    passcommand->bag.sender=id;
    cmdMesgQ.push_back (cmd->bag);
#ifdef MDEBUG
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s CMDQ +1 to %d\n",id.sndump(mdbout,79),cmdMesgQ.size());
#endif

    POSE_invoke (recv (passcommand), Switch, channels[dchannel].dest.idAsInt(), channels[dchannel].cost);
  }
  else if(cmd->bag.src==id)
    { // our command failed put it back in the queue
      DataMesgEnvBag mymesg(cmd->bag.command.mid);
      deque <DataMesgEnvBag>::iterator mesgiter=find(outMesgQ.begin(),
						 outMesgQ.end(), mymesg);
      //if our message isn't in our outQ we're screwed
      CkAssert(mesgiter !=outMesgQ.end());
      connectReqQ.push_front(cmd->bag.command.mid);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s cnctQ +1 to %d\n",id.sndump(mdbout,79),connectReqQ.size());
#endif

#ifdef DEBUG
      char sout[80];
      memset(sout,0,80);
      parent->CommitPrintf("[NetSim: switch %s push_fronting", id.sndump(sout,79));
      parent->CommitPrintf(" mesg %s onto connectReqQ\n", cmd->bag.command.mid.sndump(sout,79));
#endif 
    }
  else
    {// tell them their command failed
      ReplyBag newbag(success,id,cmd->bag.src,cmd->bag.sender,id,cmd->bag.command.mid,cmd->bag.id,false);
      Reply *myreply = new Reply (newbag);
      POSE_invoke (recv (myreply), Switch, cmd->bag.sender.idAsInt(), getcost(cmd->bag.sender));
    }
  delete(cmd);
}

// The method by which other nodes communicate with us for data packets
//*  consumes bandwidth
void Switch::recv (Packet *m)
{ // try to pass it along; if the chanlock succeeded then the route was 
  // established so just get the route
  Label key=m->bag.mid;

  char sout[80];
  memset(sout,0,80);
  char foo[80];
  memset(foo,0,80);

  map < Label, OutnBack >::const_iterator miter=packetroute.find(key);
  if ((miter!=packetroute.end()) &&(miter->first==key)) {
#ifdef DEBUG    
    parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
    parent->CommitPrintf(" forwarding mesg %s ",m->bag.mid.sndump(sout,79));
    parent->CommitPrintf(" to %s ",channels[miter->second.first].dest.sndump(foo,79));
    parent->CommitPrintf("packet %d time %d evid %s cost %d \n",m->bag.sequence,m->timestamp,  parent->eq->currentPtr->evID.sndump(foo,79), channels[miter->second.first].cost);
#endif 
    Packet *passpack = new Packet(m->bag);
    POSE_invoke(recv(passpack), Switch, channels[miter->second.first].dest.idAsInt(), channels[miter->second.first].cost);
  }
  else { //   add to message
    //   issue print of message receipt
    //   if message complete issue the done

    DataMesg mymesg(m->bag.mid);
    deque <DataMesg>::iterator mesgiter=find(inMesgQ.begin(),inMesgQ.end(),mymesg);
    if (mesgiter==inMesgQ.end()) {
#ifdef DEBUG
      parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
      parent->CommitPrintf(" got mesg %s packet %d time %d evid %s\n", m->bag.mid.sndump(sout,79),m->bag.sequence,m->timestamp,  parent->eq->currentPtr->evID.sndump(foo,79));
#endif 
      parent->CommitError("ERROR: Switch %s",id.sndump(sout,79));
      parent->CommitError(" CANNOT find mesg id %s to append packet %d\n",m->bag.mid.sndump(sout,79),m->bag.sequence);
      // the sky it is a falling upon us
      //   printf error
      //   next implementation we'll reply with failure 
    }
    else { //insert the packet
      //CkPrintf("Switch %s got mid %s packet %d.\n",id.sdump(),m->bag.mid.sdump(),m->bag.sequence);

#ifdef DEBUG
      // tracking for phantom packets
      parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
      parent->CommitPrintf(" appending mesg %s packet %d time %d evid %s\n", m->bag.mid.sndump(sout,79),m->bag.sequence,m->timestamp,  parent->eq->currentPtr->evID.sndump(foo,79));
#endif

      mesgiter->rcvdpacks++;
      if (mesgiter->rcvdpacks>=mesgiter->numpackets) {
	// pull up the stored reply to the lock
	// it will have the correct enveloping info
	ReplyBag myreply(true,m->bag.mid);
	deque <ReplyBag>::iterator repliter=find(replyQ.begin(),replyQ.end(),myreply);
	if (repliter==replyQ.end()) {
	  parent->CommitError("ERROR: cannot find reply for %s in replyQ\n",m->bag.mid.sndump(sout,79));
	  //		  while(repliter !=replyQ.end())
	  //{repliter->dump();repliter++;}
	}
	else {
	  ReplyBag newbag(true,repliter->src,repliter->dest,repliter->intermed,id,m->bag.mid,repliter->cid,true);
	  Reply *evreply=new Reply(newbag);
	  POSE_invoke (recv (evreply), Switch, repliter->intermed.idAsInt(), getcost(repliter->intermed));
	  replyQ.erase(repliter);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s RQ -1 to %d\n",id.sndump(mdbout,79),replyQ.size());
#endif

	  
	  // SEND TO BGPROC HERE
	  // mesgIter contains that TaskData we need to talk to the
	  // appropriate BGprocs
	  // Build TaskMsg
	  int myNodePID = switchPIDToNodePID(parent->thisIndex);
	  int myNode = switchPIDToNode(parent->thisIndex);
	  TaskMsg *tm = new TaskMsg(mesgiter->td.srcNode, mesgiter->td.msgID,
		     mesgiter->td.index, mesgiter->td.recvTime,
		     mesgiter->td.msgSize, myNode,
 		     mesgiter->td.destNode, mesgiter->td.destTID);
	  // Now we need to figure out where this thing goes
//	  int myNode = parent->thisIndex - (netLength*netHeight*netWidth)*numWth;
          POSE_invoke(recvIncomingMsg(tm), BGnode, myNodePID, 0);
#ifdef DEBUG
	  parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
	  parent->CommitPrintf(" message %s received at final destination switch.\n...myNodePID=%d destNode=%d destTID=%d numWth=%d]\n", m->bag.mid.sndump(sout,79),myNodePID, mesgiter->td.destNode, mesgiter->td.destTID, numWth);
#endif 
        }
	inMesgQ.erase(mesgiter);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s IMQ -1 to %d\n",id.sndump(mdbout,79),inMesgQ.size());
#endif

      }
    }
  }
}


// normal methods
//PRE: we have a chanlocked channel 
//POSE: message sent
bool Switch::sendMesg(Label  mid)
{
  DataMesgEnvBag mymesg(mid);
  deque <DataMesgEnvBag>::iterator mesgiter=find(outMesgQ.begin(),outMesgQ.end(),mymesg);
  //  DataMesg *copy;
  //  *copy = mesgiter->mesg; 
  char sout[80];
  memset(sout,0,80);
  map < Label, OutnBack >::const_iterator miter=packetroute.find(mid);
  if (mesgiter == outMesgQ.end()) {

    parent->CommitError("ERROR: Switch[%s]:", id.sndump(sout,79));
    parent->CommitError("sendMesg has no mesg matching %s in outMesgQ \n",  mid.sndump(sout,79));
    return false;
  }
  else if ((miter != packetroute.end()) && (miter->first == mid)) {
    //    CkPrintf("Switch[%s]:sendMesg sending %s\n", id.sdump(), mid.sdump());
    int dchannel=packetroute[mid].first;
    int dest=channels[dchannel].dest.idAsInt();  
    // invent the packets
    bool last=false;
    unsigned long timeperpacket=1;
    unsigned long packperunittime=(unsigned long) (channels[dchannel].bandwidth/(double) mesgiter->mesg.maxpacksize);

#ifdef DEBUG
    parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
    parent->CommitPrintf(" sending message %s to switch %d\n", mid.sndump(sout,79),dest);
#endif    
    if (mesgiter->mesg.maxpacksize>channels[dchannel].bandwidth)      
      // takes longer than one time unit to transmit a packet
      timeperpacket = (unsigned long) fabs(trunc(((double) mesgiter->mesg.maxpacksize)/channels[dchannel].bandwidth));
    if (packperunittime == 0 && timeperpacket<1)  CmiAbort("Bandwidth and packet size calculation failure.\n");
    char sout[80];
    if(packperunittime==0)// fix for remainder packets.
      packperunittime=1;
    memset(sout,0,80);    
    for (unsigned long seq=0; seq<mesgiter->mesg.numpackets; seq++) {
      Label npid=GetLabel();
      if (seq+1 == mesgiter->mesg.numpackets)
	last=true;
      PacketBag newbag(npid,mid,seq,last);
      Packet *npacket= new Packet(newbag);
#ifdef DEBUG      
      parent->CommitPrintf("[NetSim: switch %s", id.sndump(sout,79));
      parent->CommitPrintf("to dest %s", channels[dchannel].dest.sndump(sout,79));
      parent->CommitPrintf(" sending mesg %s packet %d  timeperpacket %lu\n", mid.sndump(sout,79),seq,timeperpacket);
#endif
      if (timeperpacket>1)
	POSE_invoke (recv (npacket), Switch, dest, channels[dchannel].cost+ (int) (timeperpacket*seq) );
      else
	POSE_invoke (recv (npacket), Switch, dest, channels[dchannel].cost+ (int) (seq/packperunittime) );

    }
  }
  else {
    if ((miter == packetroute.end()) || (!(miter->first == mid)))
      {
	parent->CommitError("ERROR: Switch[%s]:\n", id.sndump(sout,79));
	parent->CommitError("sendMesg has no route to send %s\n", mid.sndump(sout,79));
      }
    else
      {
	parent->CommitError("ERROR: Switch[%s]:", id.sndump(sout,79));
	parent->CommitError("sendMesg has no mesg matching %s in outMesgQ \n", mid.sndump(sout,79));
      }
    return false;
  }
  return true;
}

void Switch::channelAvailable()
{
  if (connectReqQ.empty()) return;
  Label mid = connectReqQ.front();
#ifdef DEBUG
  char sout[80];
  memset(sout,0,80);
  parent->CommitPrintf("[NetSim: switch %s pop_fronting", id.sndump(sout,79));
  memset(sout,0,80);
  parent->CommitPrintf(" mesg %s from connectReqQ\n", connectReqQ.front().sndump(sout,79));
#endif
  connectReqQ.pop_front();
  netconnect(mid);

}

void Switch::netconnect(Label  mid)
{
  DataMesgEnvBag mymesg(mid);
  deque <DataMesgEnvBag>::iterator mesgiter=find(outMesgQ.begin(),
						 outMesgQ.end(), mymesg);
  // send the chanlock command to ourself
  if ((mesgiter!=outMesgQ.end())&&(mymesg.mid==mesgiter->mid)) {
    // see if there is one channel available
    // if not available, buffer it
    int  dchannel = findTheChannel(mesgiter->dest,id);
#if 0		// 1 disabled
dchannel = 0;
#endif
    if (dchannel >= 6) {
      connectReqQ.push_back(mid);
#ifdef MDEBUG
    char mdbout[80];
  memset(mdbout,0,80);
  parent->CommitPrintf("N %s cnctQ +1 to %d\n",id.sndump(mdbout,79),connectReqQ.size());
#endif

#ifdef DEBUG
      char sout[80];
      memset(sout,0,80);
      parent->CommitPrintf("[NetSim: switch %s push_backing", id.sndump(sout,79));
      parent->CommitPrintf(" mesg %s onto connectReqQ\n", mid.sndump(sout,79));
#endif 
    }
    else {
      cmdOp ncmd(chanlock,mesgiter->mid);
      Label ncid=GetLabel();
      //                 id, src,dest,sender,command, numDataPackets,packsize,td
      CommandBag newbag(ncid,id,mesgiter->dest,id,ncmd,mesgiter->mesg.numpackets,mesgiter->mesg.maxpacksize,mesgiter->mesg.td);
      Command *selfcmd= new Command(newbag);
      //      POSE_local_invoke(recv(selfcmd), 0);
      lockAndSend(dchannel, selfcmd);
    }
    //CkPrintf("Switch %s in netconnect -- channel lock attempt src:%s dest:%s sender:%s.\n", id.sdump(), id.sdump(), mesgiter->dest.sdump(), id.sdump());
  }
}

int Switch::findTheChannel(Label dest,Label back)
{
  Chandoublepair weights[6];
  // find netdistance to dest for each neighbor to weight them
  // random selection from weighted distribution
  // Not coming up with how to do this with generic algorithm
  int avail=0;
  for (int i=0;i<6;i++) {
    if(channels[i].chanlock.test()) { //this sucker is locked route around
      weights[i].first=i;
      weights[i].second=INT_MAX;
    }
    else if (channels[i].dest == back) { //you may not reverse course
      weights[i].first=i;
      weights[i].second=INT_MAX;
    }
    else if (channels[i].dest==dest) { // if the channel leads to dest cut the search and return it
      return i;
    }
    else if((!(channels[i].dest.isnull()))&& (!(dest.isnull()))) {
      weights[i].first=i;
      weights[i].second=nodemap->netdistance(id,channels[i].dest,dest);
      avail ++;
    }
    else {
      weights[i].first=i;
      weights[i].second=INT_MAX;
    }
  }
  if (avail == 0) return 6;
  // right now weights has the netdistances in it.
  //nth_element(&weights[0],&weights[0]+1,&weights[6],PairSecondComp());
  sort(&weights[0],&weights[6],PairSecondComp());
  double minnetdistance=weights[0].second;
//  CmiPrintf("netdistance: %s %s %f %f %f %f %f %f\n", dest.sdump(), back.sdump(), weights[0].second, weights[1].second, weights[2].second, weights[3].second, weights[4].second,weights[5].second);
  if(minnetdistance==INT_MAX)
    return 6;
  /*  else { //randomly select from the minimums 
    typedef pair<Chandoublepair*,Chandoublepair*> dppair;
    dppair matches=equal_range(&weights[0],&weights[6],weights[0],PairSecondComp());
    int pick=rand()%(matches.second-matches.first);
    int range = matches.second-matches.first;
    pick = lastChannel%range;
    lastChannel++;  if (lastChannel==6) lastChannel=0;
    CmiAssert(pick>=0 && pick<6);
    return(weights[pick].first);
  }
  */
  else //just return the first one
    return(weights[0].first);

}

DataMesgEnv *ConvertAndInitiate(int sN, int mI, int id, int dN, int dT, int rT,
				int mS, int mxPktSz, int ts, int inSrc, int realDest)
{
  TaskData td(sN, mI, id, dN, dT, rT, mS);
  int pktnum = mS / mxPktSz;
  if(mS % mxPktSz)
    pktnum += 1;

  Label src(inSrc, 0);
  Label dest(realDest, 0);
//  Label nmid=GetLabel();
  Label nmid= Label();
  DataMesg dm(nmid, mxPktSz, pktnum, td);
  DataMesgEnvBag dmeb(ts, src, dest, dm);
  DataMesgEnv *dme = new DataMesgEnv(dmeb);
  return dme;
}

void Switch::recv_anti(Packet *m)
{
  restore(this);
}
                                                                                
void Switch::recv_anti(Command *m)
{
  restore(this);
}
                                                                                
void Switch::recv_anti(Reply *m)
{
  restore(this);
}

// several small utility functions

int Switch::switchPIDToNodePID(int switchpid)
{
  return switchpid - (netLength*netHeight*netWidth);
}

int nodeToSwitchPID(int destnode)
{
  return (netLength*netHeight*netWidth*(numWth+1) + destnode);
}

int switchPIDToNode(int switchpid)
{
  return switchpid - (netLength*netHeight*netWidth)*(numWth+1);
}

