/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import projections.analysis.NoiseMiner;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;

public class NoiseMinerWindow
extends ProjectionsWindow
implements ItemListener {
    private static final long serialVersionUID = 1L;
    NoiseMinerWindow thisWindow = this;
    int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private DefaultTableModel tableModel;
    private JTable table;
    private JPanel chartJPanel;
    private final Vector columnNames;
    private JButton setRanges;
    JTextArea mainText;
    private JScrollPane mainTextScroller;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;
    NoiseMiner noiseMiner;
    public String buttonColumnTitle;
    public int numColumns;

    protected void windowInit() {
    }

    public NoiseMinerWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Computational Noise Miner :  " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.buttonColumnTitle = new String("Exemplar Timelines");
        this.columnNames = new Vector();
        this.columnNames.add(new String("Noise Duration"));
        this.columnNames.add(new String("Seen on Processors"));
        this.columnNames.add(new String("Occurrences"));
        this.columnNames.add(new String("Periodicity"));
        this.columnNames.add(new String("Likely Source of Noise"));
        this.columnNames.add(new String(this.buttonColumnTitle));
        this.numColumns = 6;
        this.mainText = new JTextArea("", 4, 30);
        this.mainTextScroller = new JScrollPane(this.mainText);
        this.mainTextScroller.setHorizontalScrollBarPolicy(32);
        this.mainPanel = new JPanel();
        this.setLayout(this.mainPanel);
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setSize(1000, 500);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        JButton b;
        if (e.getSource() instanceof JButton && (b = (JButton)e.getSource()) == this.setRanges) {
            this.showDialog();
        }
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    NoiseMinerWindow.this.noiseMiner = new NoiseMiner(NoiseMinerWindow.this.startTime, NoiseMinerWindow.this.endTime, NoiseMinerWindow.this.validPEs);
                    NoiseMinerWindow.this.noiseMiner.gatherData(NoiseMinerWindow.this.thisWindow);
                    NoiseMinerWindow.this.mainText.setText(NoiseMinerWindow.this.noiseMiner.getText());
                    NoiseMinerWindow.this.addResultsToTable(NoiseMinerWindow.this.noiseMiner.getResultsTable());
                    NoiseMinerWindow.this.addDataToHistogram(NoiseMinerWindow.this.noiseMiner.usPerDisplayBin(), NoiseMinerWindow.this.noiseMiner.histogramToDisplay);
                    return null;
                }

                public void finished() {
                }
            };
            worker.start();
        }
    }

    private void addDataToHistogram(double binwidth_us, long[] data) {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        XYSeries s = new XYSeries((Comparable)((Object)"All Event Types"), true, false);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= 0L) continue;
            s.add((double)i, data[i]);
            System.out.println("data[" + i + "]=" + data[i]);
        }
        dataset.addSeries(s);
        NumberAxis domainAxis = new NumberAxis("Event Duration (not in Microseconds)");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis rangeAxis = new NumberAxis("Number of Events");
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setDrawBarOutline(true);
        XYPlot plot = new XYPlot(dataset, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart("Event Durations Histogram (Click & Drag to zoom)", plot);
        ChartPanel chartpanel = new ChartPanel(chart);
        this.chartJPanel.removeAll();
        this.chartJPanel.setLayout(new BorderLayout());
        this.chartJPanel.add((Component)chartpanel, "Center");
        this.chartJPanel.validate();
        this.chartJPanel.repaint();
    }

    void addResultsToTable(Vector data) {
        this.tableModel = new DefaultTableModel(data, this.columnNames);
        this.table.setModel(this.tableModel);
        ButtonColumn bc = new ButtonColumn();
        this.table.getColumn(this.buttonColumnTitle).setCellRenderer(bc);
        this.table.getColumn(this.buttonColumnTitle).setCellEditor(bc);
        this.table.revalidate();
        this.table.repaint();
    }

    private void CreateLayout() {
        JPanel noiseMinerResultPanel = new JPanel();
        DefaultTableModel tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table = new JTable(tableModel);
        JScrollPane resultTable = new JScrollPane(this.table);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Results", resultTable);
        this.chartJPanel = new JPanel();
        tabbedPane.addTab("Histogram Plot", this.chartJPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.add(this.setRanges);
        this.mainPanel.add((Component)tabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPanel, "South");
    }

    public void itemStateChanged(ItemEvent ae) {
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    public void showWindow() {
    }

    class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        JButton editButton = new JButton();
        Object editObject = null;

        public ButtonColumn() {
            this.editButton.setFocusPainted(false);
            this.editButton.addActionListener(this);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JButton) {
                JButton button = (JButton)value;
                if (hasFocus) {
                    button.setForeground(table.getForeground());
                    button.setBackground(UIManager.getColor("Button.background"));
                } else if (isSelected) {
                    button.setForeground(table.getSelectionForeground());
                    button.setBackground(table.getSelectionBackground());
                } else {
                    button.setForeground(table.getForeground());
                    button.setBackground(UIManager.getColor("Button.background"));
                }
                return button;
            }
            System.out.println("getTableCellRendererComponent() on a non-JButton");
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editObject = value;
            if (value instanceof JButton) {
                JButton button = (JButton)value;
                String text = button.getText();
                this.editButton.setText(text);
                return this.editButton;
            }
            System.out.println("getTableCellEditorComponent() on a non-JButton");
            return null;
        }

        public Object getCellEditorValue() {
            return this.editObject;
        }

        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
            int whichColumnHasButtons = -1;
            for (int i = 0; i < NoiseMinerWindow.this.numColumns; ++i) {
                if (NoiseMinerWindow.this.table.getColumnName(i).compareTo(NoiseMinerWindow.this.buttonColumnTitle) != 0) continue;
                whichColumnHasButtons = i;
            }
            Object o = NoiseMinerWindow.this.table.getValueAt(NoiseMinerWindow.this.table.getSelectedRow(), whichColumnHasButtons);
            if (o instanceof NoiseMiner.NoiseResultButton) {
                ((NoiseMiner.NoiseResultButton)o).display();
            }
        }
    }
}

