/*
 * Decompiled with CFR 0.152.
 */
package charm.ccs;

import charm.ccs.CcsServer;
import charm.ccs.PythonAbstract;
import charm.ccs.PythonIterator;

public class PythonExecute
extends PythonAbstract {
    private static final int localmagic = 37492037;
    private int codeLength;
    private String code;
    private int methodNameLength;
    private String methodName;
    private int infoSize;
    private PythonIterator info;
    private int interpreter;
    private byte flags;
    private static final int memorySize = 48;
    private static final byte FLAG_PERSISTENT = -128;
    private static final byte FLAG_KEEPPRINT = 64;
    private static final byte FLAG_HIGHLEVEL = 32;
    private static final byte FLAG_ITERATE = 16;
    private static final byte FLAG_WAIT = 8;
    private static final byte FLAG_NOCHECK = 4;

    public PythonExecute(String _code, boolean _persistent, boolean _highlevel, int _interp) {
        this.magic = 37492085;
        this.codeLength = _code.length();
        this.code = _code;
        this.methodNameLength = 0;
        this.infoSize = 0;
        this.flags = 0;
        if (_persistent) {
            this.flags = (byte)(this.flags | 0xFFFFFF80);
            this.flags = (byte)(this.flags | 0x40);
        }
        if (_highlevel) {
            this.flags = (byte)(this.flags | 0x20);
        }
        this.interpreter = _interp;
    }

    public PythonExecute(String _code, String _method, PythonIterator _info, boolean _persistent, boolean _highlevel, int _interp) {
        this.magic = 37492085;
        this.codeLength = _code.length();
        this.code = _code;
        this.methodNameLength = _method.length();
        this.methodName = _method;
        this.infoSize = _info.size();
        this.info = _info;
        this.flags = (byte)16;
        if (_persistent) {
            this.flags = (byte)(this.flags | 0xFFFFFF80);
            this.flags = (byte)(this.flags | 0x40);
        }
        if (_highlevel) {
            this.flags = (byte)(this.flags | 0x20);
        }
        this.interpreter = _interp;
    }

    public void setCode(String _set) {
        this.codeLength = _set.length();
        this.code = _set;
    }

    public void setMethodName(String _set) {
        this.methodNameLength = _set.length();
        this.methodName = _set;
    }

    public void setIterator(PythonIterator _set) {
        this.infoSize = _set.size();
        this.info = _set;
    }

    public void setPersistent(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 0xFFFFFF80) : (byte)(this.flags & 0x7F);
    }

    public void setIterate(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public void setHighLevel(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    public void setKeepPrint(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    public void setWait(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public void setNoCheck(boolean _set) {
        this.flags = _set ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public void setInterpreter(int i) {
        this.interpreter = i;
    }

    public boolean isPersistent() {
        return (this.flags & 0xFFFFFF80) != 0;
    }

    public boolean isIterate() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isHighLevel() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isKeepPrint() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isKeepWait() {
        return (this.flags & 8) != 0;
    }

    public boolean isNoCheck() {
        return (this.flags & 4) != 0;
    }

    public int getInterpreter() {
        return this.interpreter;
    }

    public int size() {
        return 48 + this.codeLength + 1 + this.methodNameLength + 1 + this.infoSize;
    }

    public byte[] pack() {
        byte[] result = new byte[this.size()];
        System.out.println("Code: " + this.codeLength + ", method: " + this.methodNameLength + ", info: " + this.infoSize);
        CcsServer.writeInt(result, 0, this.magic);
        CcsServer.writeInt(result, 4, this.codeLength);
        CcsServer.writeInt(result, 24, this.methodNameLength);
        CcsServer.writeInt(result, 28, this.infoSize);
        CcsServer.writeInt(result, 40, this.interpreter);
        result[44] = this.flags;
        CcsServer.writeString(result, 48, this.codeLength + 1, this.code);
        if (this.methodNameLength > 0) {
            CcsServer.writeString(result, 48 + this.codeLength + 1, this.methodNameLength + 1, this.methodName);
        }
        if (this.infoSize > 0) {
            CcsServer.writeBytes(result, 48 + this.codeLength + this.methodNameLength + 2, this.infoSize, this.info.pack());
        }
        return result;
    }

    public void unpack() {
    }

    public void print() {
    }
}

