/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.CpdUtil;
import charm.debug.EpCheckBox;
import charm.debug.EpTreeCheckBox;
import charm.debug.EpTreeListener;
import charm.debug.EpTreeRenderer;
import charm.debug.GdbProcess;
import charm.debug.ParDebug;
import charm.debug.PythonScript;
import charm.debug.pdata.ChareInfo;
import charm.debug.pdata.CharePList;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import charm.debug.preference.PyFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PythonDialog
extends JDialog
implements ActionListener {
    private ParDebug parent;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem menuOpen;
    private JMenuItem menuSave;
    private JMenu menuRecent;
    private JComboBox chare;
    private JTextArea input;
    private JScrollPane inputScrollPane;
    private JScrollPane entryScrollPane;
    private JButton confirm;
    private JButton cancel;
    PythonScript script;

    public PythonDialog(ParDebug parent, boolean modal, CharePList chareItems, ChareTypePList chareTypeItems, GdbProcess gdb, CpdUtil server) {
        super((Frame)null, "Python script", modal);
        ChareInfo type;
        this.parent = parent;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.script = new PythonScript(gdb);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane top = new JSplitPane(1);
        top.setResizeWeight(0.5);
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BorderLayout());
        this.chare = new JComboBox();
        this.chare.addItem("Select one...");
        int i = 0;
        while ((type = chareItems.elementAt(i)) != null) {
            this.chare.addItem(type);
            ++i;
        }
        topLeft.add((Component)this.chare, "North");
        this.input = new JTextArea("", 20, 40);
        this.input.setText("def method(self):\n\t");
        this.input.setTabSize(4);
        this.input.setToolTipText("Write your python code here");
        this.inputScrollPane = new JScrollPane(this.input);
        topLeft.add(this.inputScrollPane);
        top.setLeftComponent(topLeft);
        this.entryScrollPane = new JScrollPane();
        EpPList epItems = parent.getEpItems();
        DefaultMutableTreeNode[] chareRoots = new DefaultMutableTreeNode[chareTypeItems.size()];
        Vector items = epItems.getUserEps();
        int l = items.size();
        i = 0;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode userRoot = new DefaultMutableTreeNode("User Entries");
        for (i = 0; i < l; ++i) {
            EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
            chkbox.addActionListener(this);
            chkbox.setActionCommand("entry");
            int chareType = ((EpInfo)items.elementAt(i)).getChareType();
            if (chareRoots[chareType] == null) {
                chareRoots[chareType] = new DefaultMutableTreeNode(chareTypeItems.elementAt(chareType).getType());
                userRoot.add(chareRoots[chareType]);
            }
            chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
        }
        items = epItems.getSystemEps();
        l = items.size();
        DefaultMutableTreeNode sysRoot = new DefaultMutableTreeNode("System Entries");
        for (i = 0; i < l; ++i) {
            EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
            chkbox.addActionListener(this);
            chkbox.setActionCommand("entry");
            int chareType = ((EpInfo)items.elementAt(i)).getChareType();
            if (chareRoots[chareType] == null) {
                chareRoots[chareType] = new DefaultMutableTreeNode(chareTypeItems.elementAt(chareType).getType());
                sysRoot.add(chareRoots[chareType]);
            }
            chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
        }
        root.add(sysRoot);
        root.add(userRoot);
        JTree treeBP = new JTree(root);
        treeBP.setRootVisible(false);
        treeBP.collapseRow(0);
        treeBP.expandRow(1);
        treeBP.addMouseListener(new EpTreeListener(treeBP));
        treeBP.setCellRenderer(new EpTreeRenderer());
        treeBP.getSelectionModel().setSelectionMode(1);
        this.entryScrollPane.setViewportView(treeBP);
        top.setRightComponent(this.entryScrollPane);
        this.getContentPane().add(top);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createHorizontalGlue());
        this.confirm = new JButton("Send");
        this.confirm.setActionCommand("ok");
        this.confirm.addActionListener(this);
        this.confirm.setToolTipText("Execute the python script to the application");
        buttons.add(this.confirm);
        buttons.add(Box.createRigidArea(new Dimension(30, 1)));
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttons, "South");
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuOpen = new JMenuItem("Open", 79);
        this.menuFile.add(this.menuOpen);
        this.menuOpen.setActionCommand("open");
        this.menuOpen.addActionListener(this);
        this.menuSave = new JMenuItem("Save...", 83);
        this.menuFile.add(this.menuSave);
        this.menuSave.setActionCommand("save");
        this.menuSave.addActionListener(this);
        this.menuRecent = new JMenu("Recent codes");
        this.menuFile.add(this.menuRecent);
        this.updateRecentConfig();
        this.setJMenuBar(this.menuBar);
        this.pack();
        this.setVisible(true);
    }

    private void updateRecentConfig() {
        Object[] files = this.parent.getPreferences().getRecentPython();
        this.menuRecent.removeAll();
        if (files.length > 0) {
            this.menuRecent.setEnabled(true);
            for (int i = 0; i < files.length; ++i) {
                JMenuItem item = new JMenuItem((String)files[i]);
                item.setActionCommand("openRecent");
                item.addActionListener(this);
                this.menuRecent.add(item);
            }
        } else {
            this.menuRecent.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            if (this.chare.getSelectedIndex() == 0) {
                JOptionPane.showMessageDialog(this, "Must select an object on which to execute the script", "Error", 0);
                return;
            }
            this.script.setChare((ChareInfo)this.chare.getSelectedItem());
            try {
                this.script.parseCode(this.input.getText());
            }
            catch (ParseException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            }
            this.parent.getPreferences().addRecentPython(this.input.getText());
            this.setVisible(false);
            this.parent.executePython(this.script);
        } else if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        } else if (e.getActionCommand().equals("entry")) {
            EpCheckBox chkbox = (EpCheckBox)e.getSource();
            if (chkbox.isSelected()) {
                this.script.addEP(chkbox.ep);
            } else {
                this.script.removeEP(chkbox.ep);
            }
        } else if (e.getActionCommand().equals("openRecent")) {
            JMenuItem item = (JMenuItem)e.getSource();
            this.input.setText(item.getText());
        } else if (e.getActionCommand().equals("open")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new PyFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.loadPythonCode(chooser.getSelectedFile());
            }
        } else if (e.getActionCommand().equals("save")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new PyFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                int response;
                File filename = chooser.getSelectedFile();
                if (!filename.getName().endsWith(".py")) {
                    filename = new File(filename.getAbsolutePath() + ".py");
                }
                if (filename.exists() && (response = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the file?", "File overwrite", 0)) != 0) {
                    return;
                }
                this.savePythonCode(filename);
            }
        }
    }

    boolean loadPythonCode(File f) {
        try {
            this.input.setText(this.script.loadPythonCode(f));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to load file '" + f.getName() + "'", "Error", 0);
            return false;
        }
        return true;
    }

    boolean savePythonCode(File f) {
        try {
            this.script.savePythonCode(f, this.input.getText());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to save file '" + f.getName() + "'", "Error", 0);
            return false;
        }
        return true;
    }
}

