/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ScaleSlider
extends Canvas
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private double min = 0.0;
    private double value = 0.0;
    private double max = 100.0;
    private double tickStart = 0.0;
    private double tickSep = 10.0;
    private int orient;
    private ValueListener myListener;
    private int hw = 7;
    private int totalThickness = 16;
    private double val2slope;
    private double val2offset;
    private double coor2slope;
    private double coor2offset;
    private Image offscreen;
    private int off_w = -1;
    private int off_h = -1;

    public ScaleSlider(int Norient) {
        this.orient = Norient;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private final double coor2val(int coor) {
        return this.coor2slope * (double)coor + this.coor2offset;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.totalThickness, this.totalThickness);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.totalThickness, this.totalThickness);
    }

    public double getValue() {
        return this.value;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        this.updateValue(evt);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.updateValue(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.updateValue(evt);
    }

    public void paint(Graphics dest_g) {
        int x;
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.off_w != w || this.off_h != h) {
            this.off_w = w;
            this.off_h = h;
            this.offscreen = this.createImage(this.off_w, this.off_h);
        }
        Graphics g = this.offscreen.getGraphics();
        if (this.orient == 1) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        this.setVal2coor(w);
        int[] nArray = new int[8];
        nArray[3] = h;
        nArray[4] = w;
        nArray[5] = h;
        nArray[6] = w;
        int[] back = nArray;
        this.poly(g, back, Color.black, true, 0, 0);
        int loS = 2;
        int loE = h - 4;
        int[] nArray2 = new int[8];
        nArray2[0] = this.hw;
        nArray2[2] = this.hw;
        nArray2[3] = loS;
        nArray2[4] = w - this.hw;
        nArray2[5] = loE;
        nArray2[6] = w - this.hw;
        int[] loTri = nArray2;
        this.poly(g, loTri, Color.blue, true, 0, 0);
        double cur = this.tickStart;
        while ((x = this.val2coor(cur)) <= w - this.hw) {
            int[] nArray3 = new int[4];
            nArray3[0] = x;
            nArray3[2] = x;
            nArray3[3] = h;
            int[] tick = nArray3;
            this.poly(g, tick, Color.black, false, 0, 0);
            cur += this.tickSep;
        }
        x = this.val2coor(this.value);
        int yh = 1;
        int ym = yh + this.hw;
        int yl = h - 3;
        int[] t = new int[]{x + this.hw, ym, x + this.hw, yl, x - this.hw, yl, x - this.hw, ym, x, yh};
        this.poly(g, t, Color.lightGray, true, 0, 0);
        int[] tCr = new int[]{t[8], t[9], t[0], t[1]};
        this.poly(g, tCr, Color.gray, false, 0, 0);
        int[] tA = new int[]{t[4], t[5], t[6], t[7], t[8], t[9]};
        this.poly(g, tA, Color.white, false, 0, 0);
        int[] tB = new int[]{t[0], t[1], t[2], t[3], t[4], t[5]};
        this.poly(g, tB, Color.darkGray, false, 0, 0);
        dest_g.drawImage(this.offscreen, 0, 0, null);
    }

    private void poly(Graphics g, int[] coords, Color color, boolean withFill, int shiftX, int shiftY) {
        int[] xc = new int[coords.length / 2];
        int[] yc = new int[coords.length / 2];
        g.setColor(color);
        int xo = 0;
        int yo = 1;
        if (this.orient == 1) {
            xo = 1;
            yo = 0;
        }
        int i = 0;
        while (i < xc.length) {
            xc[i] = coords[i * 2 + xo] + shiftX;
            yc[i] = coords[i * 2 + yo] + shiftY;
            ++i;
        }
        if (withFill) {
            g.fillPolygon(xc, yc, xc.length);
        } else {
            g.drawPolyline(xc, yc, xc.length);
        }
    }

    public void setMax(double m) {
        this.max = m;
        this.repaint();
    }

    public void setMin(double m) {
        this.min = m;
        this.repaint();
    }

    public void setTicks(double start, double delta) {
        this.tickStart = start;
        this.tickSep = delta;
        this.repaint();
    }

    private void setVal2coor(int screenSize) {
        this.val2slope = this.max - this.min == 0.0 ? (double)((screenSize - 2 * this.hw) / 1) : (double)(screenSize - 2 * this.hw) / (this.max - this.min);
        this.val2offset = (double)this.hw - this.val2slope * this.min;
        this.coor2slope = 1.0 / this.val2slope;
        this.coor2offset = -this.val2offset / this.val2slope;
    }

    public void setValue(double v) {
        this.value = v;
        this.repaint();
    }

    public void setValueListener(ValueListener dest) {
        this.myListener = dest;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void updateValue(MouseEvent evt) {
        double oldValue;
        double newValue;
        int coor = evt.getX();
        if (this.orient == 1) {
            coor = evt.getY();
        }
        if ((newValue = this.coor2val(coor)) < this.min) {
            newValue = this.min;
        }
        if (newValue > this.max) {
            newValue = this.max;
        }
        if (newValue != (oldValue = this.getValue())) {
            this.setValue(newValue);
            if (this.myListener != null) {
                this.myListener.sliderChanged(this);
            }
        }
    }

    private final int val2coor(double val) {
        return (int)(this.val2slope * val + this.val2offset + 0.5);
    }

    public static interface ValueListener {
        public void sliderChanged(ScaleSlider var1);
    }
}

