/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.IntervalCapableReader;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;
import projections.analysis.RLEBlock;

public class SumDetailReader
extends ProjectionsReader
implements IntervalCapableReader {
    public static final int NUM_TAGS = 2;
    public static final int TOTAL_TIME = 0;
    public static final int NUM_MSGS = 1;
    public double versionNum;
    public int myPE;
    public int numPE;
    public int numIntervals;
    public int numEPs;
    public double intervalSize;
    private Vector[][] rawData;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;

    public SumDetailReader(String filename, double Nversion) {
        super(filename, String.valueOf(Nversion));
    }

    protected boolean checkAvailable() {
        File sourceFile = new File(this.sourceString);
        return sourceFile.canRead();
    }

    protected void readStaticData() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.sourceString));
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.checkNextString("ver");
        this.versionNum = this.tokenizer.nextNumber("Version Number");
        this.tokenizer.checkNextString("cpu");
        this.myPE = (int)this.tokenizer.nextNumber("processor number");
        this.numPE = (int)this.tokenizer.nextNumber("number of processors");
        this.tokenizer.checkNextString("numIntervals");
        this.numIntervals = (int)this.tokenizer.nextNumber("numIntervals");
        this.tokenizer.checkNextString("numEPs");
        this.numEPs = (int)this.tokenizer.nextNumber("number of entry methods");
        this.tokenizer.checkNextString("intervalSize");
        this.intervalSize = this.tokenizer.nextScientific("processor usage sample interval");
        if (10 != this.tokenizer.nextToken()) {
            throw new ProjectionsFormatException(this.expectedVersion, "extra garbage at end of header line");
        }
        this.reader.close();
        this.reader = null;
    }

    protected void read() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.sourceString));
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.skipLine();
        this.rawData = new Vector[2][this.numEPs];
        int type = 0;
        while (type < 2) {
            int ep = 0;
            while (ep < this.numEPs) {
                this.rawData[type][ep] = new Vector();
                ++ep;
            }
            ++type;
        }
        while (-1 != this.tokenizer.nextToken()) {
            if (this.tokenizer.ttype != -3) {
                throw new IOException("Bad Sumdetail format-label expected");
            }
            String label = this.tokenizer.sval;
            if (label.equals("ExeTimePerEPperInterval")) {
                this.buildTable(0);
                continue;
            }
            if (!label.equals("EPCallTimePerInterval")) continue;
            this.buildTable(1);
        }
        this.reader.close();
        this.reader = null;
    }

    public void reset() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildTable(int type) throws IOException {
        int epIdx = 0;
        int intervalsLeft = this.numIntervals;
        double value = 0.0;
        int count = 1;
        block3: while (10 != this.tokenizer.nextToken()) {
            switch (this.tokenizer.ttype) {
                case -2: {
                    RLEBlock newBlock;
                    value = this.tokenizer.nval;
                    count = 1;
                    if (-3 == this.tokenizer.nextToken()) {
                        String temp = this.tokenizer.sval;
                        if (!temp.startsWith("+")) throw new IOException("Bad SumDetail Format - invalid data in run-length encoded block.");
                        count = Integer.parseInt(temp.substring(1));
                    } else {
                        this.tokenizer.pushBack();
                    }
                    while (count > intervalsLeft) {
                        newBlock = new RLEBlock();
                        newBlock.value = value;
                        newBlock.count = intervalsLeft;
                        this.rawData[type][epIdx++].add(newBlock);
                        count -= intervalsLeft;
                        intervalsLeft = this.numIntervals;
                    }
                    if (count < intervalsLeft) {
                        newBlock = new RLEBlock();
                        newBlock.value = value;
                        newBlock.count = count;
                        this.rawData[type][epIdx].add(newBlock);
                        intervalsLeft -= count;
                        break;
                    }
                    if (count != intervalsLeft) continue block3;
                    newBlock = new RLEBlock();
                    newBlock.value = value;
                    newBlock.count = count;
                    this.rawData[type][epIdx++].add(newBlock);
                    intervalsLeft = this.numIntervals;
                    break;
                }
                default: {
                    throw new IOException("Bad SumDetail Format - number expected.");
                }
            }
        }
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(double intervalSize, long startInterval, long endInterval) {
    }

    public void loadIntervalData(long startInterval, long endInterval) {
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public Vector[] getData(int type) {
        return this.rawData[type];
    }
}

