/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

class AsciiIntegerReader {
    private Reader file;
    private char[] buffer = new char[1000];
    private int idx = 0;
    private int len = 0;
    private char last;

    public AsciiIntegerReader(Reader fromFile) {
        this.file = fromFile;
        this.last = '\u0000';
    }

    public void close() throws IOException {
        this.len = 0;
        this.idx = 0;
        this.buffer = null;
        this.file.close();
        this.file = null;
    }

    public void fillBuffer() throws IOException {
        this.idx = 0;
        this.len = this.file.read(this.buffer, 0, 1000);
        if (this.len <= 0) {
            throw new EOFException();
        }
    }

    public long skip(long n) throws IOException {
        int charsSkipped = 0;
        if ((long)this.idx + n <= (long)this.len) {
            charsSkipped = (int)((long)charsSkipped + n);
            this.idx = (int)((long)this.idx + n);
        } else {
            this.idx += (charsSkipped += this.len - this.idx);
            long temp = this.file.skip(n - (long)charsSkipped);
            if (temp > 0L) {
                charsSkipped = (int)((long)charsSkipped + temp);
                try {
                    this.fillBuffer();
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }
        return charsSkipped;
    }

    public void seek(long n) throws IOException {
        this.skip(n - (long)this.idx);
    }

    public final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }

    public final char nextChar() throws IOException {
        if (this.idx >= this.len) {
            this.fillBuffer();
        }
        return this.buffer[this.idx++];
    }

    public final int nextInt() throws IOException {
        return (int)this.nextLong();
    }

    public void nextLine() throws IOException {
        if (this.last == '\n') {
            this.last = '\u0000';
            return;
        }
        while (this.nextChar() != '\n') {
        }
    }

    public String readLine() throws IOException {
        char temp;
        StringBuffer buffer = new StringBuffer();
        if (this.last == '\n') {
            this.last = '\u0000';
            return "";
        }
        while ((temp = this.nextChar()) != '\n') {
            buffer.append(temp);
        }
        return buffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final long nextLong() throws IOException {
        long ret;
        int multiplier;
        block5: {
            char c;
            block4: {
                multiplier = 1;
                while (this.isSpace(c = this.nextChar())) {
                }
                if (c == '-') {
                    multiplier = -1;
                    this.last = c = this.nextChar();
                }
                ret = this.toDigit(c);
                if (!true) break block4;
                this.last = c = this.nextChar();
                if (this.isSpace(c)) break block5;
            }
            do {
                ret = 10L * ret + (long)this.toDigit(c);
                this.last = c = this.nextChar();
            } while (!this.isSpace(c));
        }
        return ret * (long)multiplier;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public String nextString() throws IOException {
        StringBuffer ret;
        block4: {
            char c;
            block3: {
                while (this.isSpace(c = this.nextChar())) {
                }
                ret = new StringBuffer();
                ret.append(c);
                if (!true) break block3;
                this.last = c = this.nextChar();
                if (this.isSpace(c)) break block4;
            }
            do {
                ret.append(c);
                this.last = c = this.nextChar();
            } while (!this.isSpace(c));
        }
        return ret.toString();
    }

    public final int toDigit(char c) {
        return c - 48;
    }
}

