/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.ComplexFloatFFT_Mixed;

public class ComplexFloat2DFFT {
    int nrows;
    int ncols;
    ComplexFloatFFT rowFFT;
    ComplexFloatFFT colFFT;

    public ComplexFloat2DFFT(int nrows, int ncols) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.rowFFT = new ComplexFloatFFT_Mixed(ncols);
        this.colFFT = nrows == ncols ? this.rowFFT : new ComplexFloatFFT_Mixed(nrows);
    }

    protected void checkData(float[] data, int rowspan) {
        if (rowspan < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + rowspan + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * rowspan > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + rowspan + " data.length=" + data.length);
        }
    }

    public void transform(float[] data) {
        this.transform(data, 2 * this.ncols);
    }

    public void transform(float[] data, int rowspan) {
        this.checkData(data, rowspan);
        int i = 0;
        while (i < this.nrows) {
            this.rowFFT.transform(data, i * rowspan, 2);
            ++i;
        }
        int j = 0;
        while (j < this.ncols) {
            this.colFFT.transform(data, 2 * j, rowspan);
            ++j;
        }
    }

    public float[] toWraparoundOrder(float[] data) {
        return data;
    }

    public float[] toWraparoundOrder(float[] data, int rowspan) {
        if (rowspan == 2 * this.ncols) {
            return data;
        }
        float[] newdata = new float[2 * this.nrows * this.ncols];
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                newdata[i * 2 * this.ncols + 2 * j] = data[i * rowspan + 2 * j];
                newdata[i * 2 * this.ncols + 2 * j + 1] = data[i * rowspan + 2 * j + 1];
                ++j;
            }
            ++i;
        }
        return newdata;
    }

    public void backtransform(float[] data) {
        this.backtransform(data, 2 * this.ncols);
    }

    public void backtransform(float[] data, int rowspan) {
        this.checkData(data, rowspan);
        int i = 0;
        while (i < this.nrows) {
            this.rowFFT.backtransform(data, i * rowspan, 2);
            ++i;
        }
        int j = 0;
        while (j < this.ncols) {
            this.colFFT.backtransform(data, 2 * j, rowspan);
            ++j;
        }
    }

    public float normalization() {
        return 1.0f / ((float)this.nrows * (float)this.ncols);
    }

    public void inverse(float[] data) {
        this.inverse(data, 2 * this.ncols);
    }

    public void inverse(float[] data, int rowspan) {
        this.backtransform(data, rowspan);
        float norm = this.normalization();
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                int n = i * rowspan + 2 * j;
                data[n] = data[n] * norm;
                int n2 = i * rowspan + 2 * j + 1;
                data[n2] = data[n2] * norm;
                ++j;
            }
            ++i;
        }
    }
}

