/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.LabelPanel;
import projections.gui.Timeline.LayeredPanel;
import projections.gui.Timeline.TimelineScrollPaneLayout;

public class ScrollingPanel
extends JPanel {
    JScrollPane scrollpane;
    JPanel mainPanel;
    LayeredPanel axisPanel;
    LabelPanel labelPanel;
    Data data;

    public ScrollingPanel(Data data_, JPanel mainPanel_, LayeredPanel axisPanel_, LabelPanel labelPanel_) {
        this.data = data_;
        this.mainPanel = mainPanel_;
        this.axisPanel = axisPanel_;
        this.labelPanel = labelPanel_;
        this.scrollpane = new JScrollPane();
        this.scrollpane.setLayout(new TimelineScrollPaneLayout(this.data));
        this.mainPanel.setAutoscrolls(false);
        this.labelPanel.setAutoscrolls(false);
        this.axisPanel.setAutoscrolls(false);
        this.scrollpane.setViewportView(this.mainPanel);
        this.scrollpane.setRowHeaderView(this.labelPanel);
        this.scrollpane.setColumnHeaderView(this.axisPanel);
        this.scrollpane.setCorner("UPPER_LEFT_CORNER", new Corner());
        this.scrollpane.setCorner("LOWER_LEFT_CORNER", new Corner());
        this.scrollpane.setCorner("UPPER_RIGHT_CORNER", new Corner());
        this.scrollpane.setCorner("LOWER_RIGHT_CORNER", new Corner());
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        this.scrollpane.getViewport().setBackground(this.data.getBackgroundColor());
        this.scrollpane.getViewport().setScrollMode(2);
        this.axisPanel.setVisible(true);
        this.mainPanel.setVisible(true);
        this.labelPanel.setVisible(true);
        this.setVisible(true);
        this.data.SetToolTipDelaySmall();
        ToolTipManager.sharedInstance().registerComponent(this.mainPanel);
    }

    void refreshDisplay(boolean doRevalidate) {
        if (doRevalidate) {
            this.data.invalidateSelection();
            this.revalidate();
            this.scrollpane.revalidate();
            this.mainPanel.revalidate();
            this.axisPanel.revalidate();
            this.labelPanel.revalidate();
        }
        this.repaint();
        this.scrollpane.repaint();
        this.mainPanel.repaint();
        this.axisPanel.repaint();
        this.labelPanel.repaint();
    }

    public class Corner
    extends JComponent {
        protected void paintComponent(Graphics g) {
            g.setColor(ScrollingPanel.this.data.getBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

