/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.ParDebug;
import charm.debug.fmt.PList;
import charm.debug.fmt.PString;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.InspectPanel;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.SuperClassElement;
import charm.debug.pdata.GenericInfo;
import java.nio.ByteBuffer;

public class ChareInfo
extends GenericInfo {
    String name;
    byte[] id;
    GenericType type;
    ByteBuffer memory;
    int groupID;

    ChareInfo(String n, byte[] i, GenericType t, ByteBuffer m, int g) {
        this.name = n;
        this.id = i;
        this.type = t;
        this.memory = m;
        this.groupID = g;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public String toString() {
        return this.name + (this.groupID != -1 ? " (" + this.groupID + ")" : "");
    }

    @Override
    public void getDetails(InspectPanel panel) {
        if (this.type != null) {
            SuperClassElement el = new SuperClassElement(this.type, 0);
            panel.load(el, this.memory);
        } else if (this.id != null) {
            int nItems = ParDebug.server.getListLength("charm/object", ParDebug.currentListedPE);
            PList list = ParDebug.server.getPList("charm/object", ParDebug.currentListedPE, 0, nItems, this.id);
            if (list == null) {
                panel.clear();
                return;
            }
            PList cur = (PList)list.elementAt(0);
            this.type = Inspector.getTypeCreate(((PString)cur.elementNamed("type")).getString());
            this.memory = ByteBuffer.wrap(((PString)cur.elementNamed("value")).getBytes()).order(Inspector.getByteOrder());
            System.out.println("Loaded type " + this.name);
            SuperClassElement el = new SuperClassElement(this.type, 0);
            panel.load(el, this.memory);
        }
    }
}

