/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import projections.analysis.Chare;
import projections.analysis.ProjDefs;
import projections.misc.LogLoadException;

public class StsReader
extends ProjDefs {
    private boolean hasPAPI = false;
    private double version;
    private String Machine;
    private int NumPe;
    private int TotalChares;
    private int EntryCount;
    private int TotalMsgs;
    private String[] ClassNames;
    private Chare[] ChareList;
    private long[] MsgTable;
    private int entryIndex = 0;
    private Hashtable entryNames = new Hashtable();
    private Hashtable entryChareNames = new Hashtable();
    private Hashtable entryFlatToID = new Hashtable();
    private Hashtable entryIDToFlat = new Hashtable();
    private int userEventIndex = 0;
    private Hashtable userEventIndices = new Hashtable();
    private Hashtable userEvents = new Hashtable();
    private String[] userEventNames;
    private int functionEventIndex = 0;
    private Hashtable functionEventIndices = new Hashtable();
    private Hashtable functionEvents = new Hashtable();
    private String[] functionEventNames;
    private int numPapiEvents;
    private String[] papiEventNames;

    public StsReader(String FileName) throws LogLoadException {
        this(FileName, false);
    }

    public StsReader(String FileName, boolean isMultirun) throws LogLoadException {
        try {
            String Line;
            BufferedReader InFile = new BufferedReader(new InputStreamReader(new FileInputStream(FileName)));
            while ((Line = InFile.readLine()) != null) {
                Integer key;
                int ID;
                StringTokenizer st = new StringTokenizer(Line);
                String s1 = st.nextToken();
                if (s1.equals("VERSION")) {
                    this.version = Double.parseDouble(st.nextToken());
                    continue;
                }
                if (s1.equals("MACHINE")) {
                    this.Machine = st.nextToken();
                    continue;
                }
                if (s1.equals("PROCESSORS")) {
                    this.NumPe = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (s1.equals("TOTAL_CHARES")) {
                    this.TotalChares = Integer.parseInt(st.nextToken());
                    this.ChareList = new Chare[this.TotalChares];
                    this.ClassNames = new String[this.TotalChares];
                    continue;
                }
                if (s1.equals("TOTAL_EPS")) {
                    this.EntryCount = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (s1.equals("TOTAL_MSGS")) {
                    this.TotalMsgs = Integer.parseInt(st.nextToken());
                    this.MsgTable = new long[this.TotalMsgs];
                    continue;
                }
                if (s1.equals("CHARE") || Line.equals("BOC")) {
                    ID = Integer.parseInt(st.nextToken());
                    this.ChareList[ID] = new Chare();
                    this.ChareList[ID].ChareID = ID;
                    this.ChareList[ID].NumEntries = 0;
                    this.ChareList[ID].Name = st.nextToken();
                    this.ChareList[ID].Type = new String(s1);
                    this.ClassNames[ID] = this.ChareList[ID].Name;
                    continue;
                }
                if (s1.equals("ENTRY")) {
                    String Type2 = st.nextToken();
                    ID = Integer.parseInt(st.nextToken());
                    StringBuffer nameBuf = new StringBuffer(st.nextToken());
                    String Name = nameBuf.toString();
                    if (-1 != Name.indexOf(40) && -1 == Name.indexOf(41)) {
                        String tmp;
                        do {
                            tmp = st.nextToken();
                            nameBuf.append(" ");
                            nameBuf.append(tmp);
                        } while (!tmp.endsWith(")"));
                    }
                    Name = nameBuf.toString();
                    int ChareID = Integer.parseInt(st.nextToken());
                    int MsgID = Integer.parseInt(st.nextToken());
                    this.entryFlatToID.put(this.entryIndex, ID);
                    this.entryIDToFlat.put(ID, this.entryIndex);
                    ++this.entryIndex;
                    this.getEntryNames().put(ID, Name);
                    this.getEntryChareNames().put(ID, this.ClassNames[ChareID]);
                    continue;
                }
                if (s1.equals("MESSAGE")) {
                    ID = Integer.parseInt(st.nextToken());
                    int Size = Integer.parseInt(st.nextToken());
                    this.MsgTable[ID] = Size;
                    continue;
                }
                if (s1.equals("FUNCTION")) {
                    key = new Integer(st.nextToken());
                    if (!this.functionEvents.containsKey(key)) {
                        String functionEventName = "";
                        while (st.hasMoreTokens()) {
                            functionEventName = functionEventName + st.nextToken() + " ";
                        }
                        this.functionEvents.put(key, functionEventName);
                        this.functionEventNames[this.functionEventIndex] = functionEventName;
                        this.functionEventIndices.put(key, new Integer(this.functionEventIndex));
                    }
                    ++this.functionEventIndex;
                    continue;
                }
                if (s1.equals("EVENT")) {
                    key = new Integer(st.nextToken());
                    if (this.userEvents.containsKey(key)) continue;
                    String eventName = "";
                    while (st.hasMoreTokens()) {
                        eventName = eventName + st.nextToken() + " ";
                    }
                    this.userEvents.put(key, eventName);
                    this.userEventNames[this.userEventIndex] = eventName;
                    this.userEventIndices.put(key, new Integer(this.userEventIndex++));
                    continue;
                }
                if (s1.equals("TOTAL_EVENTS")) {
                    this.userEventNames = new String[Integer.parseInt(st.nextToken())];
                    continue;
                }
                if (s1.equals("TOTAL_FUNCTIONS")) {
                    this.functionEventNames = new String[Integer.parseInt(st.nextToken())];
                    continue;
                }
                if (s1.equals("TOTAL_PAPI_EVENTS")) {
                    this.hasPAPI = true;
                    this.numPapiEvents = Integer.parseInt(st.nextToken());
                    this.papiEventNames = new String[this.numPapiEvents];
                    continue;
                }
                if (s1.equals("PAPI_EVENT")) {
                    this.hasPAPI = true;
                    this.papiEventNames[Integer.parseInt((String)st.nextToken())] = st.nextToken();
                    continue;
                }
                if (!s1.equals("END")) continue;
                break;
            }
            InFile.close();
        }
        catch (FileNotFoundException e) {
            throw new LogLoadException(FileName, 0);
        }
        catch (IOException e) {
            throw new LogLoadException(FileName, 1);
        }
    }

    public double getVersion() {
        return this.version;
    }

    public int getEntryCount() {
        return this.EntryCount;
    }

    public int getProcessorCount() {
        return this.NumPe;
    }

    public String getMachineName() {
        return this.Machine;
    }

    public String getEntryNameByID(int ID) {
        return (String)this.getEntryNames().get(ID);
    }

    public String getEntryNameByIndex(int index) {
        return (String)this.getEntryNames().get(this.entryFlatToID.get(index));
    }

    public String getEntryChareNameByID(int ID) {
        return (String)this.getEntryChareNames().get(ID);
    }

    public String getEntryChareNameByIndex(int index) {
        return (String)this.getEntryChareNames().get(this.entryFlatToID.get(index));
    }

    public String getEntryFullNameByID(int ID) {
        return this.getEntryChareNameByID(ID) + "::" + this.getEntryNameByID(ID);
    }

    public String getEntryFullNameByIndex(int index) {
        return this.getEntryChareNameByIndex(index) + "::" + this.getEntryNameByIndex(index);
    }

    public Integer getEntryIndex(Integer ID) {
        if (ID < 0) {
            return ID;
        }
        return (Integer)this.entryIDToFlat.get(ID);
    }

    public int getNumUserDefinedEvents() {
        return this.userEvents.size();
    }

    public Integer getUserEventIndex(int eventID) {
        Integer key = new Integer(eventID);
        if (this.userEventIndices.containsKey(key)) {
            return (Integer)this.userEventIndices.get(key);
        }
        return null;
    }

    public String getUserEventName(int eventID) {
        Integer key = new Integer(eventID);
        return (String)this.userEvents.get(key);
    }

    public String[] getUserEventNames() {
        return this.userEventNames;
    }

    public int getNumFunctionEvents() {
        if (this.functionEvents.size() == 0) {
            return 0;
        }
        return this.functionEvents.size() + 1;
    }

    public int getFunctionEventIndex(int eventID) {
        Integer key = new Integer(eventID);
        return (Integer)this.functionEventIndices.get(key);
    }

    public String getFunctionEventDescriptor(int eventID) {
        Integer key = new Integer(eventID);
        return (String)this.functionEvents.get(key);
    }

    public String[] getFunctionEventDescriptors() {
        return this.functionEventNames;
    }

    public int getNumPerfCounts() {
        if (this.hasPAPI) {
            return this.numPapiEvents;
        }
        return 0;
    }

    public String[] getPerfCountNames() {
        if (this.hasPAPI) {
            return this.papiEventNames;
        }
        return null;
    }

    public Hashtable getEntryNames() {
        return this.entryNames;
    }

    public Hashtable getEntryChareNames() {
        return this.entryChareNames;
    }
}

