/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

public class KMeansClustering {
    public static void kMeans(double[][] data, int numClusters, int[] clusterMap, double[] distanceFromClusterMean) {
        int numProcs = data.length;
        int numEPs = data[0].length;
        double[][] mean = new double[numClusters][numEPs];
        double[][] oldMean = new double[numClusters][numEPs];
        int[] clusterCounts = new int[numClusters];
        double[][] clusterMinBound = new double[numClusters][numEPs];
        for (int ep = 0; ep < numEPs; ++ep) {
            double minVal = Double.MAX_VALUE;
            double maxVal = Double.MIN_VALUE;
            for (int p = 0; p < numProcs; ++p) {
                if (data[p][ep] < minVal) {
                    minVal = data[p][ep];
                }
                if (!(data[p][ep] > maxVal)) continue;
                maxVal = data[p][ep];
            }
            double interval = (maxVal - minVal + 1.0) / (double)numClusters;
            for (int k = 0; k < numClusters; ++k) {
                mean[k][ep] = (double)(k + 1) * interval - interval / 2.0 + minVal;
            }
        }
        while (KMeansClustering.checkMean(mean, oldMean)) {
            int ep;
            int p;
            int k;
            for (k = 0; k < numClusters; ++k) {
                clusterCounts[k] = 0;
            }
            for (p = 0; p < numProcs; ++p) {
                double minDist = Double.MAX_VALUE;
                int minSample = 0;
                for (int k2 = 0; k2 < numClusters; ++k2) {
                    double tempDist = 0.0;
                    for (int ep2 = 0; ep2 < numEPs; ++ep2) {
                        tempDist += Math.pow(data[p][ep2] - mean[k2][ep2], 2.0);
                    }
                    if (!((tempDist = Math.sqrt(tempDist)) < minDist)) continue;
                    minDist = tempDist;
                    minSample = k2;
                }
                int n = minSample;
                clusterCounts[n] = clusterCounts[n] + 1;
                clusterMap[p] = minSample;
                distanceFromClusterMean[p] = minDist;
            }
            for (k = 0; k < numClusters; ++k) {
                for (ep = 0; ep < numEPs; ++ep) {
                    clusterMinBound[k][ep] = Double.MAX_VALUE;
                    mean[k][ep] = Double.MIN_VALUE;
                }
            }
            for (p = 0; p < numProcs; ++p) {
                for (ep = 0; ep < numEPs; ++ep) {
                    if (data[p][ep] < clusterMinBound[clusterMap[p]][ep]) {
                        clusterMinBound[clusterMap[p]][ep] = data[p][ep];
                    }
                    if (!(data[p][ep] > mean[clusterMap[p]][ep])) continue;
                    mean[clusterMap[p]][ep] = data[p][ep];
                }
            }
            for (k = 0; k < numClusters; ++k) {
                for (ep = 0; ep < numEPs; ++ep) {
                    mean[k][ep] = clusterCounts[k] > 0 ? (mean[k][ep] - clusterMinBound[k][ep]) / 2.0 + clusterMinBound[k][ep] : oldMean[k][ep];
                }
            }
        }
    }

    public static boolean checkMean(double[][] mean, double[][] oldMean) {
        boolean returnVal = false;
        for (int k = 0; k < mean.length; ++k) {
            for (int ep = 0; ep < mean[k].length; ++ep) {
                if (mean[k][ep] == oldMean[k][ep]) continue;
                returnVal = true;
                oldMean[k][ep] = mean[k][ep];
            }
        }
        return returnVal;
    }

    public static void printMean(double[][] mean) {
        System.out.println("Mean:");
        System.out.println("-----");
        for (int k = 0; k < mean.length; ++k) {
            System.out.print("[" + k + "]; (");
            for (int ep = 0; ep < mean[k].length; ++ep) {
                System.out.print(" " + mean[k][ep]);
            }
            System.out.println(" )");
        }
    }

    public static void outputResults(int[] clusterMap, int numClusters) {
        System.out.println("Cluster Map:");
        System.out.println("------------");
        for (int k = 0; k < numClusters; ++k) {
            System.out.print("[" + k + "]: ");
            for (int p = 0; p < clusterMap.length; ++p) {
                if (clusterMap[p] != k) continue;
                System.out.print(p + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        int numClusters = 5;
        double[][] data = new double[][]{{0.0, 5.0}, {1.0, 1.0}, {1.0, 2.0}, {1.0, 4.0}, {2.0, 1.0}, {2.0, 7.0}, {3.0, 6.0}, {3.0, 8.0}, {4.0, 9.0}, {5.0, 2.0}, {5.0, 7.0}, {6.0, 1.0}, {7.0, 2.0}, {9.0, 4.0}, {9.0, 5.0}};
        int[] clusterMap = new int[data.length];
        double[] distanceFromClusterMean = new double[data.length];
        KMeansClustering.kMeans(data, numClusters, clusterMap, distanceFromClusterMean);
        KMeansClustering.outputResults(clusterMap, numClusters);
    }
}

