/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import projections.analysis.CallTable;
import projections.gui.CallTableTextArea;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;

public class CallTableWindow
extends ProjectionsWindow
implements ItemListener {
    private static final long serialVersionUID = 1L;
    CallTableWindow thisWindow = this;
    int myRun = 0;
    CallTableTextArea textArea;
    private Label lTitle;
    private Panel titlePanel;
    private JPanel mainPanel;
    private JPanel checkBoxPanel1;
    private JPanel checkBoxPanel2;
    private JPanel controlPanel;
    private JButton setRanges;
    private CheckboxGroup cbg1;
    private Checkbox epDetailOn;
    private Checkbox epDetailOff;
    private CheckboxGroup cbg2;
    private Checkbox statsOn;
    private Checkbox statsOff;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;
    CallTable ct;
    boolean epDetailToggle;
    boolean statsToggle;

    protected void windowInit() {
    }

    public CallTableWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Call Table - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.mainPanel = new JPanel();
        this.epDetailToggle = false;
        this.statsToggle = false;
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.setRanges) {
                this.showDialog();
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    CallTableWindow.this.ct = new CallTable(CallTableWindow.this.startTime, CallTableWindow.this.endTime, CallTableWindow.this.validPEs);
                    CallTableWindow.this.ct.GatherData(CallTableWindow.this.thisWindow);
                    CallTableWindow.this.textArea.setText(CallTableWindow.this.ct.getCallTableText(CallTableWindow.this.epDetailToggle, CallTableWindow.this.statsToggle));
                    return null;
                }

                public void finished() {
                }
            };
            worker.start();
        }
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        Object[] objectArray = new Object[3];
        objectArray[0] = "Select Processors";
        objectArray[2] = "Close";
        mbar.add(Util.makeJMenu("File", objectArray, null, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    private void CreateLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.textArea = new CallTableTextArea();
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new Label("CALL TABLE", 1);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        this.cbg1 = new CheckboxGroup();
        this.epDetailOff = new Checkbox("EP Detail Off", this.cbg1, true);
        this.epDetailOff.addItemListener(this);
        this.epDetailOn = new Checkbox("EP Detail On", this.cbg1, false);
        this.epDetailOn.addItemListener(this);
        this.checkBoxPanel1 = new JPanel();
        Util.gblAdd(this.checkBoxPanel1, this.epDetailOff, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel1, this.epDetailOn, gbc, 1, 0, 1, 1, 1, 1);
        this.cbg2 = new CheckboxGroup();
        this.statsOff = new Checkbox("Statistics Off", this.cbg2, true);
        this.statsOff.addItemListener(this);
        this.statsOn = new Checkbox("Statistics On", this.cbg2, false);
        this.statsOn.addItemListener(this);
        this.checkBoxPanel2 = new JPanel();
        Util.gblAdd(this.checkBoxPanel2, this.statsOff, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel2, this.statsOn, gbc, 1, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.titlePanel, gbc, 0, 1, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.textArea, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel1, gbc, 0, 3, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel2, gbc, 0, 4, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 5, 1, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent ae) {
        if (ae.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox cb = (Checkbox)ae.getSource();
            this.setCheckboxData(cb);
            this.setCursor(new Cursor(0));
        }
    }

    public void setCheckboxData(Checkbox cb) {
        if (cb == this.epDetailOff) {
            this.epDetailToggle = false;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (cb == this.epDetailOn) {
            this.epDetailToggle = true;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (cb == this.statsOff) {
            this.statsToggle = false;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (cb == this.statsOn) {
            this.statsToggle = true;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        }
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    public void showWindow() {
    }
}

