/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ProgressMonitor;

public class ThreadManager {
    private LinkedList threads = new LinkedList();
    public int numInitialThreads;
    private String description;
    public int numConcurrentThreads;
    private Component parentWindow;

    public ThreadManager(String description, List threads, Component guiRoot) {
        this.threads.addAll(threads);
        this.description = description;
        this.numInitialThreads = threads.size();
        this.parentWindow = guiRoot;
        this.numConcurrentThreads = 16;
    }

    public void runThreads() {
        ProgressMonitor progressBar = new ProgressMonitor(this.parentWindow, this.description, "", 0, this.numInitialThreads);
        progressBar.setMillisToPopup(10);
        progressBar.setMillisToDecideToPopup(10);
        progressBar.setProgress(0);
        int totalToLoad = this.threads.size();
        progressBar.setMaximum(totalToLoad);
        if (totalToLoad < this.numConcurrentThreads) {
            this.numConcurrentThreads = totalToLoad;
        }
        LinkedList<Thread> spawnedReaders = new LinkedList<Thread>();
        while (this.threads.size() > 0 || spawnedReaders.size() > 0) {
            Thread r2;
            while (this.threads.size() > 0 && spawnedReaders.size() < this.numConcurrentThreads) {
                r2 = (Thread)this.threads.removeFirst();
                spawnedReaders.add(r2);
                r2.start();
            }
            int doneCount = totalToLoad - this.threads.size() - spawnedReaders.size();
            if (progressBar.isCanceled()) {
                for (Thread r2 : spawnedReaders) {
                    try {
                        r2.join();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Thread was interrupted. This should not ever occur");
                    }
                }
                break;
            }
            progressBar.setNote(doneCount + " of " + totalToLoad);
            progressBar.setProgress(doneCount);
            Iterator iter = spawnedReaders.iterator();
            int waitMillis = 1000;
            while (iter.hasNext()) {
                r2 = (Thread)iter.next();
                try {
                    r2.join(waitMillis);
                    waitMillis = 1;
                    if (r2.isAlive()) continue;
                    iter.remove();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread was interrupted. This should not ever occur");
                }
            }
        }
        progressBar.close();
    }
}

