/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import java.nio.ByteBuffer;
import java.util.Stack;

public abstract class TypeVisitor {
    ByteBuffer buf;
    int offset;
    int status;
    Stack seeks;
    boolean valid;
    public static final int SUPERCLASS = 2;

    public TypeVisitor(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.offset = 0;
        this.status = 0;
        this.valid = true;
        this.seeks = new Stack();
    }

    public void visit(GenericType genericType) {
        int n = genericType.getChildren();
        if (n > 0) {
            this.push();
            for (int i = 0; i < n; ++i) {
                int n2;
                GenericElement genericElement = genericType.getChild(i);
                this.seek(genericElement.getOffset());
                GenericType genericType2 = genericElement.getType();
                String string = genericType2.getName();
                String string2 = genericElement.getName();
                String string3 = null;
                if (this.valid) {
                    string3 = genericType2.getValue(this);
                }
                if ((n2 = genericElement.getPointer() + genericType2.getPointer()) > 0 && this.valid) {
                    string3 = string3 != null ? string3 + " " + GenericType.printPointer(this.buf, this.offset) : GenericType.printPointer(this.buf, this.offset);
                }
                this.addElement(genericElement, string3);
                if (n2 == 0) {
                    this.visit(genericType2);
                }
                this.revertSeek();
            }
            this.pop();
        }
    }

    public abstract Object getResult();

    public abstract void addElement(GenericElement var1, String var2);

    public void addType(String string) {
    }

    public void addName(String string) {
    }

    public void addValue(String string) {
    }

    public abstract void push();

    public abstract void pop();

    public boolean isValid() {
        return this.valid;
    }

    public void setPointer(int n) {
    }

    public void setStatus(int n) {
        this.status |= n;
    }

    public void seek(int n) {
        if (this.valid) {
            this.seeks.push(new Integer(n));
            this.offset += n;
            if (n < 0) {
                this.valid = false;
            }
        } else {
            this.seeks.push(new Integer(0));
        }
    }

    public void revertSeek() {
        int n = (Integer)this.seeks.pop();
        if (n < 0) {
            this.valid = true;
        }
        this.offset -= n;
    }

    public byte getByte() {
        return this.buf.get(this.offset);
    }

    public short getShort() {
        return this.buf.getShort(this.offset);
    }

    public int getInteger() {
        return this.buf.getInt(this.offset);
    }

    public long getLong() {
        return this.buf.getLong(this.offset);
    }

    public float getFloat() {
        return this.buf.getFloat(this.offset);
    }

    public double getDouble() {
        return this.buf.getDouble(this.offset);
    }

    public String printPointer() {
        return GenericType.printPointer(this.buf, this.offset);
    }
}

