/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AllocationGraphDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final int EVENTS_PER_BAR = 1;
    private static final int BAR_WIDTH = 2;
    private static final int VERTICAL_PIXELS = 800;
    JComboBox peList;
    JTextField firstEvent;
    JTextField lastEvent;
    JLabel numEvents;
    JTextField barWidth;
    JTextField eventsPerBar;
    JLabel hPixels;
    JTextField vPixels;
    JButton ok;
    JButton cancel;
    boolean confirmed = false;

    AllocationGraphDialog(Frame frame, boolean bl, int n) {
        super(frame, "Allocation Graph", bl);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(8, 2));
        JLabel jLabel = new JLabel("Processor number: ");
        jPanel.add(jLabel);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = new Integer(i).toString();
        }
        this.peList = new JComboBox<String>(stringArray);
        this.peList.setSelectedIndex(0);
        jPanel.add(this.peList);
        JLabel jLabel2 = new JLabel("First event: ");
        jPanel.add(jLabel2);
        this.firstEvent = new JTextField("1");
        this.firstEvent.addActionListener(this);
        this.firstEvent.getDocument().addDocumentListener(this);
        jPanel.add(this.firstEvent);
        JLabel jLabel3 = new JLabel("Last event: ");
        jPanel.add(jLabel3);
        this.lastEvent = new JTextField("1");
        this.lastEvent.addActionListener(this);
        this.lastEvent.getDocument().addDocumentListener(this);
        jPanel.add(this.lastEvent);
        JLabel jLabel4 = new JLabel("Total events: ");
        jPanel.add(jLabel4);
        int n2 = Integer.parseInt(this.lastEvent.getText()) - Integer.parseInt(this.firstEvent.getText()) + 1;
        this.numEvents = new JLabel("" + n2);
        jPanel.add(this.numEvents);
        JLabel jLabel5 = new JLabel("Events per bar: ");
        jPanel.add(jLabel5);
        this.eventsPerBar = new JTextField("1");
        this.eventsPerBar.addActionListener(this);
        this.eventsPerBar.getDocument().addDocumentListener(this);
        jPanel.add(this.eventsPerBar);
        JLabel jLabel6 = new JLabel("Bar width: ");
        jPanel.add(jLabel6);
        this.barWidth = new JTextField("2");
        this.barWidth.addActionListener(this);
        this.barWidth.getDocument().addDocumentListener(this);
        jPanel.add(this.barWidth);
        JLabel jLabel7 = new JLabel("Horizontal pixels: ");
        jPanel.add(jLabel7);
        int n3 = n2 * Integer.parseInt(this.barWidth.getText()) / Integer.parseInt(this.eventsPerBar.getText());
        this.hPixels = new JLabel("" + n3);
        jPanel.add(this.hPixels);
        JLabel jLabel8 = new JLabel("Vertical pixels: ");
        jPanel.add(jLabel8);
        this.vPixels = new JTextField("800");
        this.vPixels.addActionListener(this);
        jPanel.add(this.vPixels);
        JPanel jPanel2 = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        jPanel2.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    public int getPe() {
        return this.peList.getSelectedIndex();
    }

    public int getFirstEvent() {
        return Integer.parseInt(this.firstEvent.getText());
    }

    public int getLastEvent() {
        return Integer.parseInt(this.lastEvent.getText());
    }

    public int getEventsPerBar() {
        return Integer.parseInt(this.eventsPerBar.getText());
    }

    public int getBarWidth() {
        return Integer.parseInt(this.barWidth.getText());
    }

    public int getWidth() {
        return Integer.parseInt(this.vPixels.getText());
    }

    public int getHeight() {
        return Integer.parseInt(this.vPixels.getText());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok") || actionEvent.getSource() == this.firstEvent || actionEvent.getSource() == this.lastEvent || actionEvent.getSource() == this.eventsPerBar || actionEvent.getSource() == this.barWidth || actionEvent.getSource() == this.vPixels) {
            try {
                if (this.peList.getSelectedIndex() >= 0 && Integer.parseInt(this.firstEvent.getText()) >= 0 && Integer.parseInt(this.lastEvent.getText()) >= Integer.parseInt(this.firstEvent.getText()) && Integer.parseInt(this.eventsPerBar.getText()) > 0 && Integer.parseInt(this.barWidth.getText()) > 0 && Integer.parseInt(this.vPixels.getText()) > 10) {
                    this.confirmed = true;
                    this.setVisible(false);
                } else if (Integer.parseInt(this.firstEvent.getText()) < 0) {
                    JOptionPane.showMessageDialog(this, "The first event must be positive", "Error", 0);
                    this.firstEvent.requestFocus();
                } else if (Integer.parseInt(this.lastEvent.getText()) < Integer.parseInt(this.firstEvent.getText())) {
                    JOptionPane.showMessageDialog(this, "The last event must be greater than the first event", "Error", 0);
                    this.lastEvent.requestFocus();
                } else if (Integer.parseInt(this.eventsPerBar.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The number of events per bar must be positive", "Error", 0);
                    this.eventsPerBar.requestFocus();
                } else if (Integer.parseInt(this.barWidth.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The width of the bars must be positive", "Error", 0);
                    this.barWidth.requestFocus();
                } else if (Integer.parseInt(this.vPixels.getText()) <= 10) {
                    JOptionPane.showMessageDialog(this, "The number of vertical pixels must be greater than 10", "Error", 0);
                    this.vPixels.requestFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
            }
        }
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updatePixels();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updatePixels();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updatePixels() {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(this.firstEvent.getText());
            n2 = Integer.parseInt(this.lastEvent.getText());
            if (n3 < 0 || n2 <= n3) {
                throw new NumberFormatException();
            }
            n = n2 - n3;
            this.numEvents.setText("" + n);
        }
        catch (NumberFormatException numberFormatException) {
            this.numEvents.setText("??");
        }
        try {
            n3 = Integer.parseInt(this.numEvents.getText());
            n2 = Integer.parseInt(this.barWidth.getText());
            n = Integer.parseInt(this.eventsPerBar.getText());
            if (n2 <= 0 || n <= 0) {
                throw new NumberFormatException();
            }
            int n4 = n3 * n2 / n;
            this.hPixels.setText("" + n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.hPixels.setText("??");
        }
    }
}

