/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class PrintUtils
implements Printable {
    private Component itemToBePrinted = null;

    public PrintUtils(Component component) {
        this.itemToBePrinted = component;
    }

    public void setComponent(Component component) {
        this.itemToBePrinted = component;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        this.printComponent(g, pf);
        return 0;
    }

    private void printComponent(Graphics g, PageFormat pf) {
        Dimension componentSize = this.itemToBePrinted.getSize();
        System.out.println("Component dimensions = " + componentSize.width + "x" + componentSize.height);
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        System.out.println("Paper dimensions = " + pageWidth + "x" + pageHeight);
        double pScale = Math.min(pageWidth / (double)componentSize.width, pageHeight / (double)componentSize.height);
        ((Graphics2D)g).translate(pf.getImageableX(), pf.getImageableY());
        ((Graphics2D)g).scale(pScale, pScale);
        this.itemToBePrinted.printAll(g);
    }
}

