/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MainLayout;
import projections.gui.Timeline.MainPanelBackground;
import projections.gui.Timeline.MainPanelForeground;

public class MainPanel
extends JPanel
implements Scrollable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    int viewX;
    int viewY;
    Data data;
    MainHandler handler;

    public MainPanel(Data data, MainHandler handler) {
        this.handler = handler;
        this.data = data;
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
        this.setLayout(new MainLayout(data));
        this.add(new MainPanelForeground(data));
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void loadTimelineObjects() {
        int i;
        this.setCursor(new Cursor(3));
        this.removeAll();
        this.data.createTLOArray();
        this.add(new MainPanelForeground(this.data));
        int p = 0;
        while (p < this.data.numPs()) {
            i = 0;
            while (i < this.data.tloArray[p].length) {
                this.data.tloArray[p][i].setWhichTimeline(p);
                this.add(this.data.tloArray[p][i]);
                MouseMotionListener[] mml = this.data.tloArray[p][i].getMouseMotionListeners();
                boolean found = false;
                int mml_index = 0;
                while (mml_index < mml.length) {
                    if (mml[mml_index] == this) {
                        found = true;
                    }
                    ++mml_index;
                }
                if (!found) {
                    this.data.tloArray[p][i].addMouseListener(this);
                    this.data.tloArray[p][i].addMouseMotionListener(this);
                }
                ++i;
            }
            ++p;
        }
        if (this.data.timelineUserEventObjectsArray != null) {
            p = 0;
            while (p < this.data.numPs()) {
                if (this.data.timelineUserEventObjectsArray[p] != null) {
                    i = 0;
                    while (i < this.data.timelineUserEventObjectsArray[p].length) {
                        this.data.timelineUserEventObjectsArray[p][i].setWhichTimeline(p);
                        this.add(this.data.timelineUserEventObjectsArray[p][i]);
                        ++i;
                    }
                }
                ++p;
            }
        }
        MainPanelBackground b = new MainPanelBackground(this.data);
        b.addMouseListener(this);
        b.addMouseMotionListener(this);
        this.add(b);
        this.handler.setData(this.data);
        this.handler.refreshDisplay(true);
        this.setCursor(new Cursor(0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.data.screenHeight());
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.data.singleTimelineHeight();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.data.singleTimelineHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Data getData() {
        return this.data;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.viewX);
            int newY = p.y - (e.getY() - this.viewY);
            int maxX = this.getWidth() - jv.getWidth();
            int maxY = this.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
        this.data.displayMustBeRepainted();
    }

    public void mousePressed(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.viewX = e.getX();
            this.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

