/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Stack;
import java.util.Vector;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.gui.Timeline.TimelineMessage;

public class TimelineEvent
implements Comparable {
    public long BeginTime;
    public long EndTime;
    public long RecvTime;
    public long cpuBegin;
    public long cpuEnd;
    public int EntryPoint;
    public int SrcPe;
    public int MsgLen;
    public int EventID;
    public ObjectId id;
    public Vector MsgsSent;
    public Vector PackTimes;
    public int numPapiCounts = 0;
    public long[] papiCounts;
    public Integer UserSpecifiedData;
    public boolean isFunction = false;
    public Stack callStack;
    public String userEventName;
    public static final int USEREVENTMAXGAP = 3;

    public void setDefaultValues() {
        this.BeginTime = -1L;
        this.EndTime = -1L;
        this.RecvTime = -1L;
        this.cpuBegin = -1L;
        this.cpuEnd = -1L;
        this.EntryPoint = -1;
        this.SrcPe = -1;
        this.MsgLen = -1;
        this.EventID = -1;
        this.id = null;
        this.MsgsSent = null;
        this.PackTimes = null;
        this.numPapiCounts = 0;
        this.papiCounts = null;
    }

    public TimelineEvent(long bt, long et, int ep, int pe, int mlen, long r, ObjectId d, int eventid, long cpubegin, long cpuend, int numPapiCounts, long[] papiCounts) {
        this.setDefaultValues();
        this.BeginTime = bt;
        this.EndTime = et;
        this.cpuBegin = cpubegin;
        this.cpuEnd = cpuend;
        this.EntryPoint = ep;
        this.SrcPe = pe;
        this.MsgLen = mlen;
        this.RecvTime = r;
        this.id = new ObjectId(d);
        this.EventID = eventid;
        this.numPapiCounts = numPapiCounts;
        this.papiCounts = papiCounts;
        this.userEventName = null;
    }

    public TimelineEvent() {
        this.setDefaultValues();
    }

    public TimelineEvent(long bt, long et, int ep, int pe, int mlen) {
        this.setDefaultValues();
        this.BeginTime = bt;
        this.EndTime = et;
        this.EntryPoint = ep;
        this.SrcPe = pe;
        this.MsgLen = mlen;
        this.userEventName = null;
    }

    public TimelineEvent(long bt, long et, int ep, int pe) {
        this.setDefaultValues();
        this.BeginTime = bt;
        this.EndTime = et;
        this.EntryPoint = ep;
        this.SrcPe = pe;
        this.MsgLen = 0;
        this.userEventName = null;
    }

    public void addMessage(TimelineMessage m) {
        if (this.MsgsSent == null) {
            this.MsgsSent = new Vector();
        }
        this.MsgsSent.addElement(m);
    }

    public void addPack(PackTime p) {
        if (this.PackTimes == null) {
            this.PackTimes = new Vector();
        }
        this.PackTimes.addElement(p);
    }

    public int compareTo(Object o) {
        return (int)(this.BeginTime - ((TimelineEvent)o).BeginTime);
    }
}

