/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.ParDebug;
import charm.debug.fmt.PList;
import charm.debug.fmt.PString;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.JTreeVisitor;
import charm.debug.inspect.StringVisitor;
import charm.debug.pdata.GenericInfo;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import javax.swing.JTree;

public class ChareInfo
extends GenericInfo {
    String name;
    byte[] id;
    GenericType type;
    ByteBuffer memory;

    ChareInfo(String string, byte[] byArray, GenericType genericType, ByteBuffer byteBuffer) {
        this.name = string;
        this.id = byArray;
        this.type = genericType;
        this.memory = byteBuffer;
    }

    public String toString() {
        return this.name;
    }

    public JComponent getDetails() {
        if (this.type != null) {
            StringVisitor stringVisitor = new StringVisitor(this.memory);
            stringVisitor.visit(this.type);
            System.out.println(stringVisitor.getResult());
            JTreeVisitor jTreeVisitor = new JTreeVisitor(this.memory, this.type.getName());
            jTreeVisitor.visit(this.type);
            return (JTree)jTreeVisitor.getResult();
        }
        if (this.id != null) {
            int n = ParDebug.server.getListLength("charm/object", ParDebug.currentListedPE);
            PList pList = ParDebug.server.getPList("charm/object", ParDebug.currentListedPE, 0, n, this.id);
            if (pList == null) {
                return null;
            }
            PList pList2 = (PList)pList.elementAt(0);
            this.type = Inspector.getTypeCreate(((PString)pList2.elementNamed("type")).getString());
            this.memory = ByteBuffer.wrap(((PString)pList2.elementNamed("value")).getBytes()).order(Inspector.getByteOrder());
            System.out.println("Loaded type " + this.name);
            StringVisitor stringVisitor = new StringVisitor(this.memory);
            stringVisitor.visit(this.type);
            System.out.println(stringVisitor.getResult());
            JTreeVisitor jTreeVisitor = new JTreeVisitor(this.memory, this.type.getName());
            jTreeVisitor.visit(this.type);
            return (JTree)jTreeVisitor.getResult();
        }
        return null;
    }
}

