/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.InspectedElement;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.JTreeVisitor;
import charm.debug.inspect.VariableElement;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.ByteBuffer;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class InspectPanel
extends JPanel
implements ActionListener {
    private JScrollPane scroll;
    private JTree tree;
    int pe;

    public InspectPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.scroll = new JScrollPane();
        this.add(this.scroll);
    }

    public void load(int n, long l, GenericType genericType) {
        this.pe = n;
        System.out.println("location = " + (int)l + ", " + (int)(l >>> 32));
        PList pList = ParDebug.server.getPList("converse/memory/data", n, (int)l, (int)(l >>> 32));
        if (pList == null) {
            System.out.println("list is null!");
        }
        PList pList2 = (PList)pList.elementAt(0);
        int n2 = ((PNative)pList2.elementNamed("size")).getIntValue(0);
        System.out.println("Got memory data size = " + n2);
        if (n2 > 0) {
            ByteBuffer byteBuffer = null;
            PAbstract pAbstract = pList2.elementNamed("value");
            if (pAbstract != null) {
                byteBuffer = ByteBuffer.wrap(((PString)pAbstract).getBytes()).order(Inspector.getByteOrder());
            }
            String string = "info symbol 0x";
            string = Inspector.is64bit() ? string + Long.toHexString(byteBuffer.getLong()) : string + Integer.toHexString(byteBuffer.getInt());
            String string2 = ParDebug.infoCommand(string = string + "\n");
            if (string2.startsWith("vtable for")) {
                String string3 = string2.substring(10, string2.indexOf(43)).trim();
                GenericType genericType2 = Inspector.getTypeCreate(string3);
                JTreeVisitor jTreeVisitor = new JTreeVisitor(byteBuffer, genericType2.getName());
                jTreeVisitor.visit(genericType2);
                this.tree = (JTree)jTreeVisitor.getResult();
                this.tree.getSelectionModel().setSelectionMode(1);
                this.scroll.setViewportView(this.tree);
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Follow pointer");
                jMenuItem.setActionCommand("dereference");
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
                PopupListener popupListener = new PopupListener(jPopupMenu);
                this.tree.addMouseListener(popupListener);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("dereference")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            InspectedElement inspectedElement = (InspectedElement)defaultMutableTreeNode.getUserObject();
            if (inspectedElement.value == null) {
                return;
            }
            long l = Long.parseLong(inspectedElement.value.substring(inspectedElement.value.indexOf("0x") + 2), 16);
            if (l > 0L) {
                PList pList = ParDebug.server.getPList("converse/memory/data", this.pe, (int)l, (int)(l >>> 32));
                if (pList == null) {
                    System.out.println("list is null!");
                }
                PList pList2 = (PList)pList.elementAt(0);
                int n = ((PNative)pList2.elementNamed("size")).getIntValue(0);
                System.out.println("Got memory data size = " + n);
                if (n > 0) {
                    ByteBuffer byteBuffer = null;
                    PAbstract pAbstract = pList2.elementNamed("value");
                    if (pAbstract != null) {
                        byteBuffer = ByteBuffer.wrap(((PString)pAbstract).getBytes()).order(Inspector.getByteOrder());
                    }
                    JTreeVisitor jTreeVisitor = new JTreeVisitor(byteBuffer, inspectedElement.e.getType().getName());
                    if (inspectedElement.e.getPointer() > 1) {
                        VariableElement variableElement = new VariableElement(inspectedElement.e.getType(), null, inspectedElement.e.getType().pointerSize(), inspectedElement.e.getPointer() + inspectedElement.e.getType().getPointer() - 1, 0);
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new InspectedElement(variableElement, "0x0")));
                    } else {
                        jTreeVisitor.visit(inspectedElement.e.getType());
                        defaultMutableTreeNode.add(jTreeVisitor.top);
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            System.out.println("MouseEvent: " + mouseEvent);
            TreePath treePath = InspectPanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof InspectedElement)) {
                    return;
                }
                InspectedElement inspectedElement = (InspectedElement)defaultMutableTreeNode.getUserObject();
                System.out.println(inspectedElement);
                if (mouseEvent.isPopupTrigger() && inspectedElement.isPointer() && defaultMutableTreeNode.isLeaf()) {
                    InspectPanel.this.tree.setSelectionPath(treePath);
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

