/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class GdbProcess {
    ParDebug mainThread;
    Process gdb = null;
    public BufferedWriter gdbIn;
    public BufferedReader gdbOut;
    private FileWriter debugOutput;

    public GdbProcess(ParDebug parDebug) {
        this.mainThread = parDebug;
        try {
            this.debugOutput = new FileWriter("servthread_debug.out");
        }
        catch (IOException iOException) {
            System.out.println("Error while opening dubug output");
        }
    }

    public String infoCommand(String string) {
        CharSequence charSequence;
        if (this.gdb == null) {
            charSequence = new File(this.mainThread.getFilename()).getAbsolutePath();
            String string2 = "gdb " + (String)charSequence;
            String string3 = this.mainThread.getHostname();
            if (!string3.equals("localhost")) {
                string2 = string3 + " " + string2;
                String string4 = this.mainThread.getUsername();
                if (!string4.equals("")) {
                    string2 = "-l " + string4 + " " + string2;
                }
                string2 = "ssh " + string2;
            }
            try {
                this.gdb = Runtime.getRuntime().exec(string2);
                this.gdbIn = new BufferedWriter(new OutputStreamWriter(this.gdb.getOutputStream()));
                this.gdbOut = new BufferedReader(new InputStreamReader(this.gdb.getInputStream()));
            }
            catch (Exception exception) {
                System.out.println("Failed to start gdb info program");
                return "error";
            }
            this.infoCommand(" ");
        }
        try {
            this.gdbIn.write(string);
            this.gdbIn.flush();
            this.debugOutput.write("request: {" + string + "}");
            charSequence = new StringBuffer();
            while (!((StringBuffer)charSequence).toString().endsWith("(gdb) ")) {
                while (this.gdbOut.ready()) {
                    ((StringBuffer)charSequence).append((char)this.gdbOut.read());
                }
            }
            ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 6);
            this.debugOutput.write("reply: |" + charSequence + "|");
            this.debugOutput.flush();
            return ((StringBuffer)charSequence).toString();
        }
        catch (IOException iOException) {
            return "error";
        }
    }

    public void terminate() {
        if (this.gdb != null) {
            this.gdb.destroy();
        }
        this.gdb = null;
    }
}

