/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.File;
import projections.analysis.StsReader;
import projections.gui.OrderedIntList;

public class FileUtils {
    private static OrderedIntList[] validPEs;
    private static String[] validPEStrings;
    private static boolean[] hasFiles;

    public static String getBaseName(String filename) {
        String baseName = null;
        if (filename.endsWith(".sum.sts")) {
            baseName = filename.substring(0, filename.length() - 8);
        } else if (filename.endsWith(".sts")) {
            baseName = filename.substring(0, filename.length() - 4);
        } else {
            System.err.println("Invalid sts filename! Exiting ...");
            System.exit(-1);
        }
        return baseName;
    }

    public static String dirFromFile(String filename) {
        int index = filename.lastIndexOf(File.separator);
        if (index != -1) {
            return filename.substring(0, index);
        }
        return ".";
    }

    public static void detectFiles(StsReader sts, String baseName) {
        hasFiles = new boolean[5];
        validPEs = new OrderedIntList[5];
        validPEStrings = new String[5];
        int type = 0;
        while (type < 5) {
            FileUtils.validPEs[type] = new OrderedIntList();
            FileUtils.detectFiles(sts, baseName, type);
            FileUtils.validPEStrings[type] = validPEs[type].listToString();
            ++type;
        }
    }

    public static void detectFiles(StsReader sts, String baseName, int type) {
        File testFile = null;
        if (type == 4) {
            testFile = new File(FileUtils.getSumAccumulatedName(baseName));
            if (testFile.isFile() && testFile.length() > 0L && testFile.canRead()) {
                FileUtils.hasFiles[type] = true;
            }
            return;
        }
        File prefix = new File(baseName);
        String prefix_s = prefix.getName();
        testFile = new File(FileUtils.dirFromFile(baseName));
        if (!testFile.isDirectory()) {
            System.err.println("Internal Error: Path [" + baseName + "] " + "supplied for file detection is not a " + "directory! Please report to developers!");
            System.exit(-1);
        }
        String[] files = testFile.list();
        int file = 0;
        while (file < files.length) {
            if (files[file].endsWith(FileUtils.getTypeExtension(type)) && files[file].startsWith(prefix_s)) {
                int startIdx;
                FileUtils.hasFiles[type] = true;
                int pe = -1;
                int endIdx = files[file].lastIndexOf(".");
                if (endIdx == -1 || (startIdx = files[file].substring(0, endIdx).lastIndexOf(".")) == -1 || startIdx + 1 >= endIdx) break;
                pe = Integer.parseInt(files[file].substring(startIdx + 1, endIdx));
                validPEs[type].insert(pe);
            }
            ++file;
        }
    }

    public static boolean hasLogFiles() {
        return hasFiles[0];
    }

    public static boolean hasSumFiles() {
        return hasFiles[1];
    }

    public static boolean hasSumAccumulatedFile() {
        return hasFiles[4];
    }

    public static boolean hasSumDetailFiles() {
        return hasFiles[2];
    }

    public static boolean hasPoseDopFiles() {
        return hasFiles[3];
    }

    public static String getFileName(String baseName, int pnum, int type) {
        return String.valueOf(baseName) + "." + pnum + "." + FileUtils.getTypeExtension(type);
    }

    public static String getSumAccumulatedName(String baseName) {
        return String.valueOf(baseName) + ".sum";
    }

    public static String getTypeExtension(int type) {
        String fileExt = null;
        switch (type) {
            case 1: {
                fileExt = "sum";
                break;
            }
            case 2: {
                fileExt = "sumd";
                break;
            }
            case 0: {
                fileExt = "log";
                break;
            }
            case 3: {
                fileExt = "poselog";
                break;
            }
            default: {
                System.err.println("Internal Error: Unknown file type index " + type);
                System.exit(-1);
            }
        }
        return fileExt;
    }

    public static OrderedIntList getValidProcessorList(int type) {
        String errorMsg = "";
        switch (type) {
            case 0: {
                errorMsg = "Warning: No log files.";
                break;
            }
            case 1: {
                errorMsg = "Warning: No summary files.";
                break;
            }
            case 2: {
                errorMsg = "Warning: No summary detail files.";
                break;
            }
            case 3: {
                errorMsg = "Warning: No poselog files found.";
                break;
            }
            default: {
                System.err.println("Internal Error: Unsupported log type index " + type + " for valid processor " + "info.");
                System.exit(-1);
            }
        }
        if (!hasFiles[type]) {
            System.err.println(errorMsg);
        }
        return validPEs[type];
    }

    public static String getValidProcessorString(int type) {
        return FileUtils.getValidProcessorList(type).listToString();
    }
}

