/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.GraphData;
import projections.gui.MainWindow;
import projections.gui.Util;

public class GraphYAxisCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private GraphData data;
    private int textheight = 0;
    private int labelincrement = 0;
    private int tickincrement = 0;
    private int numintervals = 0;
    private int maxvalue = 0;
    private double pixelincrement = 0.0;
    private FontMetrics fm;

    public GraphYAxisCanvas() {
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
    }

    public int getPreferredWidth() {
        String s;
        int w = 0;
        if (this.data == null) {
            return w;
        }
        if (this.fm == null) {
            Graphics g = this.getGraphics();
            this.fm = g.getFontMetrics(g.getFont());
            g.dispose();
        }
        int max = 0;
        if (this.data.ymode == 10) {
            s = "(usec)";
            max = this.data.xmode == 0 ? this.data.processor.maxTime : this.data.interval.maxTime;
        } else {
            s = "Msgs";
            max = this.data.xmode == 0 ? this.data.processor.maxMsgs : this.data.interval.maxMsgs;
        }
        if (this.fm != null) {
            w = this.fm.stringWidth("" + max) + this.fm.stringWidth(s) + 25;
        }
        return w;
    }

    public void paint(Graphics g) {
        String s;
        if (this.data == null) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height - this.data.offset2;
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        g.setColor(MainWindow.runObject[this.myRun].background);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        int y = h / 2;
        if (this.data.ymode == 10) {
            s = "Time";
            g.drawString(s, 5, y);
            s = "(usec)";
            g.drawString(s, 5, y + this.fm.getHeight() + 5);
        } else {
            s = "Msgs";
            g.drawString(s, 5, y);
        }
        g.drawLine(w - 5, this.data.offset, w - 5, h - 1);
        int i = 0;
        while (i <= this.numintervals) {
            int cury = (int)((double)h - (double)i * this.pixelincrement) - 1;
            if (i % this.labelincrement == 0) {
                g.drawLine(w - 10, cury, w, cury);
                s = "" + i * this.tickincrement;
                g.drawString(s, w - 15 - this.fm.stringWidth(s), cury + this.fm.getHeight() / 2);
            } else {
                g.drawLine(w - 7, cury, w - 3, cury);
            }
            ++i;
        }
    }

    public void print(Graphics pg) {
        ((Graphics2D)pg).setBackground(Color.white);
        int w = this.getSize().width;
        int h = this.getSize().height;
        pg.clearRect(0, 0, w, h);
        this.paint(pg);
        ((Graphics2D)pg).setBackground(Color.black);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.textheight == 0) {
            Graphics g = this.getGraphics();
            FontMetrics fm = g.getFontMetrics(g.getFont());
            this.textheight = fm.getHeight();
            g.dispose();
        }
        this.maxvalue = this.data.ymode == 10 ? (this.data.xmode == 0 ? this.data.processor.maxTime : this.data.interval.maxTime) : (this.data.xmode == 0 ? this.data.processor.maxMsgs : this.data.interval.maxMsgs);
        if (this.maxvalue <= 0) {
            this.tickincrement = 1;
            this.numintervals = 0;
            this.pixelincrement = 1.0;
            this.labelincrement = 1;
        } else {
            this.tickincrement = (int)Math.ceil(5.0 / ((double)(h - this.data.offset - this.data.offset2) / (double)this.maxvalue));
            this.tickincrement = Util.getBestIncrement(this.tickincrement);
            this.numintervals = (int)Math.ceil((double)this.maxvalue / (double)this.tickincrement);
            this.pixelincrement = (double)(h - this.data.offset - this.data.offset2) / (double)this.numintervals;
            this.labelincrement = (int)Math.ceil((double)(this.textheight + 10) / this.pixelincrement);
            this.labelincrement = Util.getBestIncrement(this.labelincrement);
        }
        this.data.yscale = this.pixelincrement / (double)this.tickincrement;
        super.setBounds(x, y, w, h);
    }

    public void setData(GraphData data) {
        this.data = data;
    }
}

