/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.U;
import projections.gui.Util;

public class AmpiTimeProfileWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private static final long serialVersionUID = 1L;
    private AmpiTimeProfileWindow thisWindow = null;
    private EntrySelectionDialog entryDialog = null;
    static int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    private JButton saveColors;
    private JButton loadColors;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    Vector[] processProfiles = null;
    private int numFunctions;
    private String[] typeLabelNames = new String[]{"Ampi Functions"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] funcNames;
    private double[][] graphData = null;
    private double[][] outputData = null;
    private Color[] outColors = null;

    public AmpiTimeProfileWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Time Profile Graph--AMPI - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow, myWindowID);
        this.setGraphSpecificData();
        this.createLayout();
        this.thisWindow = this;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gbl);
        this.epSelection = new JButton("Select Functions");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.saveColors = new JButton("Save Function Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Function Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.epSelection, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gbc, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gbc, 3, 0, 1, 1, 0, 0);
        JPanel graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
    }

    public JPanel getAmpiMainPanel() {
        return this.mainPanel;
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Function execution time", "us");
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        this.startInterval = (int)dialog.getStartInterval();
        this.endInterval = (int)dialog.getEndInterval();
        this.processorList = dialog.getValidProcessors();
        this.processProfiles = new Vector[this.processorList.size()];
        super.getDialogData();
    }

    public void setDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        dialog.setIntervalSize(this.intervalSize);
        dialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
        }
    }

    public void showWindow() {
    }

    public void createAMPITimeProfileData(int procId, int index) {
        this.processProfiles[index] = new Vector();
        MainWindow.runObject[myRun].createAMPITimeProfile(procId, 0L, MainWindow.runObject[myRun].getTotalTime(), this.processProfiles[index]);
    }

    public void getRangeVals(long beginT, long endT, int beginI, int endI, long iSize, OrderedIntList procList) {
        this.startTime = beginT;
        this.endTime = endT;
        this.startInterval = beginI;
        this.endInterval = endI;
        this.intervalSize = iSize;
        this.processorList = procList.copyOf();
        this.processProfiles = new Vector[this.processorList.size()];
    }

    public void getRangeVals() {
    }

    private void fillGraphData() {
        int j;
        int funcCnt = 0;
        int i = 0;
        while (i < this.processProfiles.length) {
            Vector v = this.processProfiles[i];
            j = 0;
            while (j < v.size()) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(j);
                Stack funcStk = p.getFinalCallFuncStack();
                funcCnt += funcStk.size();
                ++j;
            }
            ++i;
        }
        this.numFunctions = funcCnt;
        this.outColors = ColorManager.createColorMap(funcCnt);
        this.funcNames = new String[funcCnt];
        this.colorArray = new Color[1][funcCnt];
        this.stateArray = new boolean[1][funcCnt];
        this.existsArray = new boolean[1][funcCnt];
        i = 0;
        while (i < funcCnt) {
            this.colorArray[0][i] = this.outColors[i];
            this.stateArray[0][i] = true;
            this.existsArray[0][i] = false;
            ++i;
        }
        int intervalsCnt = this.endInterval - this.startInterval + 1;
        this.outputData = new double[intervalsCnt][funcCnt];
        int i2 = 0;
        while (i2 < intervalsCnt) {
            j = 0;
            while (j < funcCnt) {
                this.outputData[i2][j] = 0.0;
                ++j;
            }
            ++i2;
        }
        funcCnt = 0;
        long rangeStart = (long)this.startInterval * this.intervalSize;
        long rangeEnd = (long)this.endInterval * this.intervalSize;
        int i3 = 0;
        while (i3 < this.processProfiles.length) {
            Vector v = this.processProfiles[i3];
            int j2 = 0;
            while (j2 < v.size()) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(j2);
                Stack funcStk = p.getFinalCallFuncStack();
                int k = 0;
                while (k < funcStk.size()) {
                    AmpiFunctionData funcData = (AmpiFunctionData)funcStk.get(k);
                    this.funcNames[funcCnt] = funcData.getFunctionName();
                    if (this.stateArray[0][funcCnt]) {
                        int l = 0;
                        while (l < funcData.execIntervalCnt()) {
                            long endTime;
                            AmpiFunctionData.AmpiFuncExecInterval oneInterval = funcData.getIntervalAt(l);
                            long startTime = oneInterval.startTimestamp > rangeStart ? oneInterval.startTimestamp : rangeStart;
                            long l2 = endTime = oneInterval.endTimestamp < rangeEnd ? oneInterval.endTimestamp : rangeEnd;
                            if (endTime > startTime) {
                                this.existsArray[0][funcCnt] = true;
                                int head = (int)((startTime - rangeStart) / this.intervalSize);
                                int tail = (int)((endTime - rangeStart) / this.intervalSize);
                                this.outputData[head][funcCnt] = (double)((long)(head + 1) * this.intervalSize + rangeStart - startTime) / (double)this.intervalSize;
                                this.outputData[tail][funcCnt] = (double)(endTime - (long)tail * this.intervalSize - rangeStart) / (double)this.intervalSize;
                                int m = head + 1;
                                while (m < tail) {
                                    this.outputData[m][funcCnt] = 1.0;
                                    ++m;
                                }
                            }
                            ++l;
                        }
                        ++funcCnt;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i3;
        }
        this.graphData = new double[this.outputData.length][];
        i3 = 0;
        while (i3 < this.outputData.length) {
            this.graphData[i3] = new double[this.outputData[i3].length];
            int j3 = 0;
            while (j3 < this.outputData[i3].length) {
                this.graphData[i3][j3] = this.outputData[i3][j3];
                ++j3;
            }
            ++i3;
        }
    }

    public void applyDialogColors() {
        int i = 0;
        while (i < this.numFunctions) {
            this.outColors[i] = this.colorArray[0][i];
            ++i;
        }
        i = 0;
        while (i < this.outputData.length) {
            int j = 0;
            while (j < this.numFunctions) {
                this.outputData[i][j] = this.stateArray[0][j] ? this.graphData[i][j] : 0.0;
                ++j;
            }
            ++i;
        }
        this.setOutputGraphData(false);
    }

    public void setOutputGraphData(boolean reCompute) {
        if (reCompute) {
            this.fillGraphData();
        }
        this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
        this.setYAxis("AMPI function Execution Time (intervals)", "");
        this.setDataSource("Time Profile Graph", this.outputData, this.outColors, this.thisWindow);
        super.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        int count = 0;
        String name = null;
        int i = 0;
        while (i < this.numFunctions) {
            if (this.stateArray[0][i] && count++ == yVal) {
                name = this.funcNames[i];
                break;
            }
            ++i;
        }
        if (name == null) {
            return null;
        }
        String[] rString = new String[]{name, "Execution Time = " + (long)(this.outputData[xVal][yVal] * (double)this.intervalSize / 1000.0) + "ms"};
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.funcNames);
                }
                this.entryDialog.showDialog();
            } else if (b == this.setRanges) {
                this.showDialog();
                this.processorList.reset();
                int index = 0;
                while (this.processorList.hasMoreElements()) {
                    int procId = this.processorList.nextElement();
                    this.createAMPITimeProfileData(procId, index++);
                }
                this.setOutputGraphData(true);
            } else if (b == this.saveColors) {
                MainWindow.runObject[myRun].saveColors();
            } else if (b == this.loadColors) {
                try {
                    ColorManager.loadActivityColors(0, this.colorArray[0]);
                    this.setOutputGraphData(false);
                }
                catch (IOException exception) {
                    System.err.println("Failed to load colors!!");
                }
            }
        }
    }
}

