/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class ParseTokenizer
extends StreamTokenizer {
    public ParseTokenizer(Reader r) {
        super(r);
    }

    public void checkNextString(String expected) throws IOException {
        String ret = this.nextString(expected);
        if (!expected.equals(ret)) {
            throw new IOException("Expected " + expected + " got " + ret);
        }
    }

    public double nextNumber(String description) throws IOException {
        if (-2 != this.nextToken()) {
            throw new IOException("Couldn't read " + description + " got " + this.toString());
        }
        return this.nval;
    }

    public double nextScientific(String description) throws IOException {
        int exponent;
        double mantissa = this.nextNumber(String.valueOf(description) + " mantissa");
        String expString = this.nextString(String.valueOf(description) + " exponent");
        char expChar = expString.charAt(0);
        if (expChar != 'e' && expChar != 'd' && expChar != 'E' && expChar != 'D') {
            throw new IOException("Couldn't find exponent in " + expString);
        }
        expString = expString.substring(1);
        try {
            exponent = Integer.parseInt(expString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Couldn't parse exponent " + expString);
        }
        return mantissa * Math.pow(10.0, exponent);
    }

    public String nextString(String description) throws IOException {
        if (-3 != this.nextToken()) {
            throw new IOException("Couldn't read string " + description + " got " + this.toString());
        }
        return this.sval;
    }

    public void skipLine() throws IOException {
        while (!this.isEOL()) {
        }
    }

    public boolean isEOL() throws IOException {
        return 10 == this.nextToken();
    }

    public boolean testEOL() throws IOException {
        if (10 != this.nextToken()) {
            this.pushBack();
            return false;
        }
        return true;
    }
}

