/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class TestRewriteTemplates
extends BaseTest {
    protected boolean debug = false;

    public void testDelete() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"", (String)string2);
    }

    public void testAction() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {new StringTemplate($ID.text)} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc\n", (String)string2);
    }

    public void testEmbeddedLiteralConstructor() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {%{$ID.text}} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc\n", (String)string2);
    }

    public void testInlineTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> template(x={$ID},y={$INT}) <<x:<x.text>, y:<y.text>;>> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"x:abc, y:34;\n", (String)string2);
    }

    public void testNamedTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> foo(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testIndirectTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> ({\"foo\"})(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testInlineTemplateInvokingLib() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> template(x={$ID.text},y={$INT.text}) \"<foo(...)>\" ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testPredicatedAlts() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {false}? foo(x={$ID.text},y={$INT.text})\n           -> foo(x={\"hi\"}, y={$ID.text})\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"hi abc\n", (String)string2);
    }

    public void testTemplateReturn() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : b {System.out.println($b.st);} ;\nb : ID INT -> foo(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testReturnValueWithTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : b {System.out.println($b.i);} ;\nb returns [int i] : ID INT {$i=8;} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"8\n", (String)string2);
    }

    public void testTemplateRefToDynamicAttributes() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na scope {String id;} : ID {$a::id=$ID.text;} b\n\t{System.out.println($b.st.toString());}\n   ;\nb : INT -> foo(x={$a::id}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteTemplates.assertEquals((String)"abc \n", (String)string2);
    }

    public void testSingleNode() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template;}\ns : a {System.out.println($a.st);} ;\na : ID -> template(x={$ID.text}) <<|<x>|>> ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc");
        TestRewriteTemplates.assertEquals((String)"|abc|\n", (String)string3);
    }

    public void testSingleNodeRewriteMode() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template; rewrite=true;}\ns : a {System.out.println(input.getTokenStream().toString(0,0));} ;\na : ID -> template(x={$ID.text}) <<|<x>|>> ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc");
        TestRewriteTemplates.assertEquals((String)"|abc|\n", (String)string3);
    }

    public void testRewriteRuleAndRewriteModeOnSimpleElements() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template; rewrite=true;}\na: ^(A B) -> {ick}\n | y+=INT -> {ick}\n | x=ID -> {ick}\n | BLORT -> {ick}\n ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestRewriteTemplates.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.warnings.size());
    }

    public void testRewriteRuleAndRewriteModeIgnoreActionsPredicates() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template; rewrite=true;}\na: {action} {action2} x=A -> {ick}\n | {pred1}? y+=B -> {ick}\n | C {action} -> {ick}\n | {pred2}?=> z+=D -> {ick}\n | (E)=> ^(F G) -> {ick}\n ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestRewriteTemplates.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.warnings.size());
    }

    public void testRewriteRuleAndRewriteModeNotSimple() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template; rewrite=true;}\na  : ID+ -> {ick}\n   | INT INT -> {ick}\n   ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestRewriteTemplates.assertEquals((String)("unexpected errors: " + errorQueue), (int)2, (int)errorQueue.warnings.size());
    }

    public void testRewriteRuleAndRewriteModeRefRule() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar TP;\noptions {ASTLabelType=CommonTree; output=template; rewrite=true;}\na  : b+ -> {ick}\n   | b b A -> {ick}\n   ;\nb  : B ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestRewriteTemplates.assertEquals((String)("unexpected errors: " + errorQueue), (int)2, (int)errorQueue.warnings.size());
    }
}

