/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.ParseTokenizer;

public class GenericSummaryReader {
    private static final int NUM_TAGS = 3;
    public static final int TOTAL_TIME = 0;
    public static final int NUM_MSGS = 1;
    public static final int MAX_TIME = 2;
    public int versionNum;
    public int myPE;
    public int numPE;
    public int numIntervals;
    public int numEPs;
    public double intervalSize;
    public int numPhases;
    public int[] processorUtil;
    public long[][] epData;
    public long[][][] phaseData;
    protected double version;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private int tokenType;

    public GenericSummaryReader(String filename, double Nversion) throws IOException {
        try {
            this.reader = new BufferedReader(new FileReader(filename));
            this.version = Nversion;
            this.read();
            this.reader.close();
            this.reader = null;
        }
        catch (IOException e) {
            throw new IOException("Error reading file " + filename + " : " + e.toString());
        }
    }

    public void read() throws IOException {
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.checkNextString("ver");
        this.versionNum = (int)this.tokenizer.nextNumber("Version Number");
        this.myPE = (int)this.tokenizer.nextNumber("processor number");
        this.numPE = (int)this.tokenizer.nextNumber("number of processors");
        this.tokenizer.checkNextString("count");
        this.numIntervals = (int)this.tokenizer.nextNumber("count");
        this.tokenizer.checkNextString("ep");
        this.numEPs = (int)this.tokenizer.nextNumber("number of entry methods");
        this.tokenizer.checkNextString("interval");
        this.intervalSize = this.tokenizer.nextScientific("processor usage sample interval");
        if (this.versionNum > 2) {
            this.tokenizer.checkNextString("phases");
            this.numPhases = (int)this.tokenizer.nextNumber("phases");
        } else {
            this.numPhases = 1;
        }
        if (10 != this.tokenizer.nextToken()) {
            throw new IOException("extra garbage at end of line 1");
        }
        this.processorUtil = new int[this.numIntervals];
        this.epData = new long[this.numEPs][3];
        int nUsageRead = 0;
        while ((this.tokenType = this.tokenizer.nextToken()) != 10 && nUsageRead < this.numIntervals) {
            if (this.tokenType == -2) {
                int val = (int)this.tokenizer.nval;
                this.processorUtil[nUsageRead++] = val;
                this.tokenType = this.tokenizer.nextToken();
                if (this.tokenType == 43) {
                    this.tokenType = this.tokenizer.nextToken();
                    if (this.tokenType != -2) {
                        System.out.println("Unrecorgnized syntax at end of line 2");
                    }
                    for (int i = 1; i < (int)this.tokenizer.nval; ++i) {
                        this.processorUtil[nUsageRead++] = val;
                    }
                    continue;
                }
                this.tokenizer.pushBack();
                continue;
            }
            System.out.println("extra garbage at end of line 2");
        }
        if (this.numIntervals != nUsageRead) {
            throw new IOException("numIntervals not agree!");
        }
        int currentUserEntry = 0;
        this.tokenType = this.tokenizer.nextToken();
        if (-3 != this.tokenType) {
            this.tokenizer.pushBack();
        }
        while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > currentUserEntry) {
            this.epData[currentUserEntry][0] = (int)this.tokenizer.nval;
            ++currentUserEntry;
        }
        if (10 != this.tokenType) {
            throw new IOException("extra garbage at end of line 3");
        }
        this.tokenType = this.tokenizer.nextToken();
        if (-3 != this.tokenType) {
            this.tokenizer.pushBack();
        }
        for (currentUserEntry = 0; -2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > currentUserEntry; ++currentUserEntry) {
            this.epData[currentUserEntry][1] = (int)this.tokenizer.nval;
        }
        if (10 != this.tokenType) {
            throw new IOException("extra garbage at end of line 4");
        }
        if ((double)this.versionNum > 3.0) {
            this.tokenType = this.tokenizer.nextToken();
            if (-3 != this.tokenType) {
                this.tokenizer.pushBack();
            }
            for (currentUserEntry = 0; -2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > currentUserEntry; ++currentUserEntry) {
                this.epData[currentUserEntry][2] = (int)this.tokenizer.nval;
            }
            if (10 != this.tokenType) {
                throw new IOException("extra garbage at end of line 5");
            }
        }
        if (-3 != (this.tokenType = this.tokenizer.nextToken())) {
            this.tokenizer.pushBack();
        }
        int numberofPairs = (int)this.tokenizer.nextNumber("Number of Marked Events");
        for (int g = 0; g < numberofPairs; ++g) {
            this.tokenizer.nextNumber("Number of Marked Events");
            this.tokenizer.nextNumber("Number of Marked Events");
        }
        if (this.numPhases > 1) {
            this.phaseData = new long[this.numPhases][this.numEPs][3];
            for (int m = 0; m < this.numPhases; ++m) {
                this.tokenizer.nextToken();
                this.tokenizer.nextToken();
                for (currentUserEntry = 0; -2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > currentUserEntry; ++currentUserEntry) {
                    this.phaseData[m][currentUserEntry][0] = (int)this.tokenizer.nval;
                }
                if (10 != this.tokenType) {
                    throw new IOException("extra stuff after (I) phase " + m);
                }
                this.tokenizer.nextToken();
                this.tokenizer.nextToken();
                for (currentUserEntry = 0; -2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > currentUserEntry; ++currentUserEntry) {
                    this.phaseData[m][currentUserEntry][1] = (int)this.tokenizer.nval;
                }
                if (10 == this.tokenType) continue;
                throw new IOException("extra stuff after (II) phase " + m);
            }
        }
        this.tokenizer = null;
    }
}

