/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

public class OrderedIntList {
    private Link head;
    private Link pre;
    private int len;

    public boolean isEmpty() {
        return this.len == 0;
    }

    public OrderedIntList copyOf() {
        int e;
        OrderedIntList listcopy = new OrderedIntList();
        this.reset();
        while ((e = this.nextElement()) != -1) {
            listcopy.insert(e);
        }
        listcopy.reset();
        return listcopy;
    }

    public int currentElement() {
        Link cur = this.nextLink();
        if (cur == null) {
            return -1;
        }
        return cur.data;
    }

    public boolean equals(OrderedIntList otherlist) {
        int e;
        if (otherlist == null) {
            return false;
        }
        if (this.size() != otherlist.size()) {
            return false;
        }
        this.reset();
        otherlist.reset();
        while ((e = this.nextElement()) != -1) {
            if (otherlist.nextElement() == e) continue;
            return false;
        }
        return true;
    }

    public boolean hasMoreElements() {
        return this.nextLink() != null;
    }

    public boolean contains(OrderedIntList otherlist) {
        int e;
        if (otherlist == null) {
            return true;
        }
        if (otherlist.size() > this.size()) {
            return false;
        }
        this.reset();
        otherlist.reset();
        while ((e = otherlist.nextElement()) != -1) {
            int me;
            while (e != (me = this.nextElement())) {
                if (me != -1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(int eleValue) {
        int me;
        this.reset();
        while ((me = this.nextElement()) != -1) {
            if (me != eleValue) continue;
            return true;
        }
        return false;
    }

    public void insert(int eleValue) {
        this.reset();
        Link tmp = this.nextLink();
        while (tmp != null && tmp.data < eleValue) {
            this.pre = tmp;
            tmp = this.nextLink();
        }
        if (tmp == null) {
            Link newLink = new Link(eleValue, tmp);
            if (this.head == null) {
                this.head = newLink;
            } else {
                this.pre.next = newLink;
            }
            ++this.len;
        } else if (tmp.data != eleValue) {
            Link newLink = new Link(eleValue, tmp);
            if (this.head == tmp) {
                this.head = newLink;
            } else {
                this.pre.next = newLink;
            }
            ++this.len;
        }
    }

    public String listToString() {
        this.reset();
        int tmp = this.nextElement();
        String result = "";
        int interval = -1;
        int max = -1;
        int min = -1;
        while (tmp != -1) {
            if (min == -1) {
                min = tmp;
                tmp = this.nextElement();
                continue;
            }
            if (interval == -1) {
                interval = tmp - min;
                max = tmp;
                tmp = this.nextElement();
                continue;
            }
            while (tmp - max == interval) {
                max = tmp;
                tmp = this.nextElement();
            }
            if (max == min + interval) {
                if (!result.equals("")) {
                    result = result + ",";
                }
                result = result + new String("" + min);
                min = max;
                interval = -1;
                continue;
            }
            if (!result.equals("")) {
                result = result + ",";
            }
            result = result + new String("" + min + "-" + max);
            if (interval > 1) {
                result = result + new String(":" + interval);
            }
            max = -1;
            interval = -1;
            min = -1;
        }
        if (min != -1) {
            if (!result.equals("")) {
                result = result + ",";
            }
            result = result + new String("" + min);
        }
        if (max != -1) {
            if (!result.equals("")) {
                result = result + ",";
            }
            result = result + new String("" + max);
        }
        return result;
    }

    public int nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
        if (this.pre == null) {
            return -1;
        }
        return this.pre.data;
    }

    private Link nextLink() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void removeAll() {
        this.len = 0;
        this.head = null;
        this.pre = null;
    }

    public void reset() {
        this.pre = null;
    }

    public int size() {
        return this.len;
    }

    class Link {
        int data;
        Link next;

        Link(int d, Link n) {
            this.data = d;
            this.next = n;
        }
    }
}

