#include <stdio.h>
#include "hello.decl.h"
#include "hello_shared.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public CBase_Main
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thisProxy;

    CProxy_Hello arr = CProxy_Hello::ckNew(nElements);

    arr[0].SayHi(17);
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

/*array [1D]*/
class Hello : public CBase_Hello
{
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
  }

  Hello(CkMigrateMessage *m) {}
  
  void SayHi(int hiNo)
  {
    //CkPrintf("Hi[%d] from element %d\n",hiNo,thisIndex);
    CkPrintf("[%d] BEFORE\n", thisIndex);
    char buf[16] __attribute__((aligned(16)));
    sprintf(buf, "%d", thisIndex);
    sendWorkRequest(FUNC_SAYHI,
                    NULL, 0,            // readWrite data
                    buf, strlen(buf)+1, // readOnly data
                    NULL, 0,            // writeOnly data
                    CthSelf()
                   );
    CthSuspend();
    CkPrintf("[%d] AFTER\n", thisIndex);
    if (thisIndex < nElements-1)
      //Pass the hello on:
      thisProxy[thisIndex+1].SayHi(hiNo+1);
    else 
      //We've been around once-- we're done.
      mainProxy.done();
  }
};

#include "hello.def.h"
