/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MemoryDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final int VERTICAL_LINES = 80;
    private static final int LINE_SIZE = 10;
    private static final int HORIZONTAL_PIXELS = 1000;
    JComboBox peList;
    JTextField scanSize;
    JTextField lines;
    JLabel vPixels;
    JTextField hPixels;
    JButton ok;
    JButton cancel;
    boolean confirmed = false;

    MemoryDialog(Frame frame, boolean bl, int n) {
        super(frame, "Memory", bl);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 2));
        JLabel jLabel = new JLabel("Processor number: ");
        jPanel.add(jLabel);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = new Integer(i).toString();
        }
        this.peList = new JComboBox<String>(stringArray);
        this.peList.setSelectedIndex(0);
        jPanel.add(this.peList);
        JLabel jLabel2 = new JLabel("Line width: ");
        jPanel.add(jLabel2);
        this.scanSize = new JTextField("16");
        this.scanSize.addActionListener(this);
        this.scanSize.getDocument().addDocumentListener(this);
        jPanel.add(this.scanSize);
        JLabel jLabel3 = new JLabel("Number of lines: ");
        jPanel.add(jLabel3);
        this.lines = new JTextField("50");
        this.lines.addActionListener(this);
        this.lines.getDocument().addDocumentListener(this);
        jPanel.add(this.lines);
        JLabel jLabel4 = new JLabel("Veritcal pixels: ");
        jPanel.add(jLabel4);
        int n2 = Integer.parseInt(this.scanSize.getText()) * Integer.parseInt(this.lines.getText());
        this.vPixels = new JLabel("" + n2);
        jPanel.add(this.vPixels);
        JLabel jLabel5 = new JLabel("Horizontal pixels: ");
        jPanel.add(jLabel5);
        this.hPixels = new JTextField("1000");
        this.hPixels.addActionListener(this);
        jPanel.add(this.hPixels);
        JPanel jPanel2 = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        jPanel2.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getPe() {
        return this.peList.getSelectedIndex();
    }

    public int getScan() {
        return Integer.parseInt(this.scanSize.getText());
    }

    public int getLines() {
        return Integer.parseInt(this.lines.getText());
    }

    public int getHPixels() {
        return Integer.parseInt(this.hPixels.getText());
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok") || actionEvent.getSource() == this.scanSize || actionEvent.getSource() == this.lines || actionEvent.getSource() == this.hPixels) {
            try {
                if (this.peList.getSelectedIndex() >= 0 && Integer.parseInt(this.scanSize.getText()) > 3 && Integer.parseInt(this.lines.getText()) > 0 && Integer.parseInt(this.hPixels.getText()) > 10) {
                    this.confirmed = true;
                    this.setVisible(false);
                } else if (Integer.parseInt(this.scanSize.getText()) <= 3) {
                    JOptionPane.showMessageDialog(this, "The width of the line must be greater than 3", "Error", 0);
                    this.scanSize.requestFocus();
                } else if (Integer.parseInt(this.lines.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The number of lines must be positive", "Error", 0);
                    this.lines.requestFocus();
                } else if (Integer.parseInt(this.hPixels.getText()) <= 10) {
                    JOptionPane.showMessageDialog(this, "The number of horizontal pixels must be greater than 10", "Error", 0);
                    this.hPixels.requestFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
            }
        }
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updatePixels();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updatePixels();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updatePixels() {
        try {
            int n = Integer.parseInt(this.scanSize.getText());
            int n2 = Integer.parseInt(this.lines.getText());
            if (n > 0 && n2 > 0) {
                int n3 = n * n2;
                this.vPixels.setText("" + n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.vPixels.setText("??");
        }
    }
}

