/*
 * Decompiled with CFR 0.152.
 */
package projections.guiUtils;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import projections.gui.Analysis;

public class ActivityManager {
    Hashtable activityMap = new Hashtable();
    Vector categoryNames = new Vector();
    Vector categoryActivities = new Vector();
    Vector activityNames = new Vector();
    Vector activityColors = new Vector();
    Vector activityProperties = new Vector();
    Color[][] cachedColors;
    boolean initialized = false;

    public void registerActivity(String string, int n, String string2) {
        if (!this.initialized) {
            if (!this.categoryNames.contains(string)) {
                this.categoryNames.add(string);
                this.categoryActivities.add(new Vector());
            }
            int n2 = this.activityNames.size();
            this.activityMap.put(string + "|" + n, new Integer(n2));
            this.activityNames.add(string2);
            int n3 = this.categoryNames.indexOf(string);
            ((Vector)this.categoryActivities.get(n3)).add(new Integer(n2));
        } else {
            System.err.println("Warning! Internal inconsistency - Projections attempting to register activities to an already initialized set.");
        }
    }

    public Color[] getColors(String string) {
        int n = this.categoryNames.indexOf(string);
        return this.cachedColors[n];
    }

    public void registrationDone() {
        this.resetColors();
        this.cachedColors = new Color[this.categoryNames.size()][];
        for (int i = 0; i < this.categoryNames.size(); ++i) {
            Vector vector = (Vector)this.categoryActivities.get(i);
            this.cachedColors[i] = new Color[vector.size()];
            for (int j = 0; j < vector.size(); ++j) {
                int n = (Integer)vector.get(j);
                this.cachedColors[i][n] = (Color)this.activityColors.get(n);
            }
        }
        this.initialized = true;
    }

    public void setColors(String string, Color[] colorArray) {
        int n = this.categoryNames.indexOf(string);
        this.cachedColors[n] = colorArray;
    }

    public void resetColors() {
        Color[] colorArray = Analysis.createColorMap(this.activityNames.size());
        for (int i = 0; i < this.activityNames.size(); ++i) {
            this.activityColors.set(i, colorArray[i]);
        }
    }

    public int getNumActivities() {
        if (this.initialized) {
            return this.activityNames.size();
        }
        return 0;
    }
}

