/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.BinDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class HistogramWindow
extends GenericGraphWindow
implements ActionListener {
    private static final int NUM_TYPES = 2;
    private static final int TYPE_TIME = 0;
    private static final int TYPE_MSG_SIZE = 1;
    JButton entrySelectionButton;
    JButton epTableButton;
    JRadioButton timeBinButton;
    JRadioButton msgSizeBinButton;
    ButtonGroup binTypeGroup;
    private double[][][] counts;
    private int binType = 0;
    public int timeNumBins;
    public long timeBinSize;
    public long timeMinBinSize;
    public int msgNumBins;
    public long msgBinSize;
    public long msgMinBinSize;
    private HistogramWindow thisWindow = this;
    private boolean newDialog;
    private DecimalFormat _format = new DecimalFormat();

    void windowInit() {
        this.timeNumBins = 100;
        this.timeBinSize = 1000L;
        this.timeMinBinSize = 0L;
        this.msgNumBins = 200;
        this.msgBinSize = 100L;
        this.msgMinBinSize = 0L;
        super.windowInit();
    }

    public HistogramWindow(MainWindow mainWindow, Integer n) {
        super("Projections Histograms", mainWindow, n);
        this.setTitle("Projections Histograms - " + Analysis.getFilename() + ".sts");
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
    }

    public void close() {
        super.close();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new BinDialog(this, "Select Histogram Time Range");
            this.newDialog = true;
        } else {
            this.setDialogData();
            this.newDialog = false;
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (HistogramWindow.this.dialog.isModified()) {
                        HistogramWindow.access$002(HistogramWindow.this, HistogramWindow.this.thisWindow.getCounts());
                    } else if (HistogramWindow.this.newDialog) {
                        HistogramWindow.access$002(HistogramWindow.this, HistogramWindow.this.thisWindow.getCounts());
                    }
                    return null;
                }

                public void finished() {
                    HistogramWindow.this.setGraphSpecificData();
                    HistogramWindow.this.refreshGraph();
                    HistogramWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        BinDialog binDialog = (BinDialog)this.dialog;
        this.timeNumBins = binDialog.getTimeNumBins();
        this.timeBinSize = binDialog.getTimeBinSize();
        this.timeMinBinSize = binDialog.getTimeMinBinSize();
        this.msgNumBins = binDialog.getMsgNumBins();
        this.msgBinSize = binDialog.getMsgBinSize();
        this.msgMinBinSize = binDialog.getMsgMinBinSize();
        super.getDialogData();
    }

    public void setDialogData() {
        BinDialog binDialog = (BinDialog)this.dialog;
        binDialog.setTimeBinSize(this.timeBinSize);
        binDialog.setTimeNumBins(this.timeNumBins);
        binDialog.setTimeMinBinSize(this.timeMinBinSize);
        binDialog.setMsgBinSize(this.msgBinSize);
        binDialog.setMsgNumBins(this.msgNumBins);
        binDialog.setMsgMinBinSize(this.msgMinBinSize);
        super.setDialogData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText().equals("Set Range")) {
                this.showDialog();
            } else if (jMenuItem.getText().equals("Close")) {
                this.close();
            }
        } else if (actionEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton.getActionCommand().equals("Execution Time")) {
                if (this.binType != 0) {
                    SwingWorker swingWorker = new SwingWorker(){

                        public Object construct() {
                            HistogramWindow.this.binType = 0;
                            HistogramWindow.this.setGraphSpecificData();
                            HistogramWindow.this.refreshGraph();
                            return null;
                        }

                        public void finished() {
                        }
                    };
                    swingWorker.start();
                }
            } else if (jRadioButton.getActionCommand().equals("Message Size") && this.binType != 1) {
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        HistogramWindow.this.binType = 1;
                        HistogramWindow.this.setGraphSpecificData();
                        HistogramWindow.this.refreshGraph();
                        return null;
                    }

                    public void finished() {
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.getText().equals("Select Entries")) {
                System.out.println("selecting entries for display");
            } else if (jButton.getText().equals("Out-of-Range EPs")) {
                System.out.println("Showing out of range entries");
            }
        }
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = super.getMainPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(new LineBorder(Color.black), "Histogram Controls"));
        this.entrySelectionButton = new JButton("Select Entries");
        this.entrySelectionButton.addActionListener(this);
        this.epTableButton = new JButton("Out-of-Range EPs");
        this.epTableButton.addActionListener(this);
        this.timeBinButton = new JRadioButton("Execution Time", true);
        this.timeBinButton.addActionListener(this);
        this.msgSizeBinButton = new JRadioButton("Message Size");
        this.msgSizeBinButton.addActionListener(this);
        this.binTypeGroup = new ButtonGroup();
        this.binTypeGroup.add(this.timeBinButton);
        this.binTypeGroup.add(this.msgSizeBinButton);
        jPanel3.add(this.timeBinButton);
        jPanel3.add(this.msgSizeBinButton);
        jPanel3.add(this.entrySelectionButton);
        jPanel3.add(this.epTableButton);
        Util.gblAdd(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 0, 0);
        return jPanel;
    }

    protected void setGraphSpecificData() {
        if (this.binType == 0) {
            this.setXAxis("Bin Interval Size (" + U.t(this.timeBinSize) + ")", "Time", this.timeMinBinSize, this.timeBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[0], (GenericGraphWindow)this.thisWindow);
        } else if (this.binType == 1) {
            this.setXAxis("Bin Interval Size (" + this._format.format(this.msgBinSize) + " bytes)", "", this.msgMinBinSize, this.msgBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[1], (GenericGraphWindow)this.thisWindow);
        }
    }

    protected void refreshGraph() {
        super.refreshGraph();
    }

    public String[] getPopup(int n, int n2) {
        if (this.binType == 0) {
            return this.getTimePopup(n, n2);
        }
        if (this.binType == 1) {
            return this.getMsgSizePopup(n, n2);
        }
        return null;
    }

    private String[] getTimePopup(int n, int n2) {
        String[] stringArray = new String[]{Analysis.getEntryName(n2), "Count: " + this.counts[0][n][n2], n < this.timeNumBins ? "Bin: " + U.t((long)n * this.timeBinSize + this.timeMinBinSize) + " to " + U.t((long)(n + 1) * this.timeBinSize + this.timeMinBinSize) : "Bin: > " + U.t((long)this.timeNumBins * this.timeBinSize + this.timeMinBinSize)};
        return stringArray;
    }

    private String[] getMsgSizePopup(int n, int n2) {
        String[] stringArray = new String[]{Analysis.getEntryName(n2), "Count: " + this.counts[1][n][n2], n < this.msgNumBins ? "Bin: " + this._format.format((long)n * this.msgBinSize + this.msgMinBinSize) + " bytes to " + this._format.format((long)(n + 1) * this.msgBinSize + this.msgMinBinSize) + " bytes" : "Bin: > " + this._format.format((long)this.msgNumBins * this.msgBinSize + this.msgMinBinSize) + " bytes"};
        return stringArray;
    }

    private double[][][] getCounts() {
        int n = Analysis.getNumUserEntries();
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        double[][][] dArrayArray = new double[][][]{new double[this.timeNumBins + 1][n], new double[this.msgNumBins + 1][n]};
        LogEntryData logEntryData = new LogEntryData();
        LogEntryData[] logEntryDataArray = new LogEntryData[2];
        for (int i = 0; i < 2; ++i) {
            logEntryDataArray[i] = new LogEntryData();
        }
        boolean[] blArray = new boolean[2];
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Reading log files", "", 0, orderedIntList.size());
        int n2 = 0;
        while (orderedIntList.hasMoreElements()) {
            int n3 = orderedIntList.nextElement();
            if (!progressMonitor.isCanceled()) {
                progressMonitor.setNote("[PE: " + n3 + " ] Reading data.");
                progressMonitor.setProgress(n2);
            } else {
                progressMonitor.close();
            }
            ++n2;
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n3), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                boolean bl = false;
                while (!bl) {
                    switch (logEntryData.type) {
                        case 2: {
                            if (logEntryData.time > this.endTime) {
                                bl = true;
                                break;
                            }
                            LogEntryData logEntryData2 = logEntryData;
                            logEntryData = logEntryDataArray[0];
                            logEntryDataArray[0] = logEntryData2;
                            blArray[0] = true;
                            break;
                        }
                        case 3: {
                            int n4;
                            if (!blArray[0]) {
                                if (logEntryData.time <= this.endTime) break;
                                bl = true;
                                break;
                            }
                            if (logEntryData.event != logEntryDataArray[0].event) {
                                blArray[0] = false;
                                break;
                            }
                            long l = logEntryData.time - logEntryDataArray[0].time;
                            long l2 = l - this.timeMinBinSize;
                            if (l2 >= 0L) {
                                n4 = (int)(l2 / this.timeBinSize);
                                if (n4 >= this.timeNumBins) {
                                    n4 = this.timeNumBins;
                                }
                                double[] dArray = dArrayArray[0][n4];
                                int n5 = logEntryData.entry;
                                dArray[n5] = dArray[n5] + 1.0;
                            }
                            blArray[0] = false;
                            break;
                        }
                        case 1: {
                            long l;
                            if (logEntryData.time > this.endTime || (l = (long)logEntryData.msglen - this.msgMinBinSize) < 0L) break;
                            int n4 = (int)(l / this.msgBinSize);
                            if (n4 >= this.msgNumBins) {
                                n4 = this.msgNumBins;
                            }
                            double[] dArray = dArrayArray[1][n4];
                            int n6 = logEntryData.entry;
                            dArray[n6] = dArray[n6] + 1.0;
                        }
                    }
                    if (bl) continue;
                    genericLogReader.nextEvent(logEntryData);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception);
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        progressMonitor.close();
        return dArrayArray;
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Select Entry Points"}, null, this);
        this.menuBar.add(Util.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("Show Longest EPs", true)}, null, this));
        super.createMenus();
    }

    static /* synthetic */ double[][][] access$002(HistogramWindow histogramWindow, double[][][] dArray) {
        histogramWindow.counts = dArray;
        return dArray;
    }
}

