/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterGraphics;
import projections.gui.Analysis;
import projections.gui.FloatTextField;
import projections.gui.GraphData;
import projections.gui.GraphDisplayCanvas;
import projections.gui.GraphTitleCanvas;
import projections.gui.GraphWAxisCanvas;
import projections.gui.GraphXAxisCanvas;
import projections.gui.GraphYAxisCanvas;
import projections.gui.Util;

public class GraphDisplayPanel
extends Container
implements ActionListener,
ItemListener,
AdjustmentListener {
    private GraphData data;
    private Panel mainPanel;
    private GraphTitleCanvas titleCanvas;
    private GraphYAxisCanvas yAxisCanvas;
    private GraphXAxisCanvas xAxisCanvas;
    private GraphWAxisCanvas wAxisCanvas;
    private GraphDisplayCanvas displayCanvas;
    private Scrollbar HSB;
    private Button bIncreaseX;
    private Button bDecreaseX;
    private Button bResetX;
    private Checkbox cbLineGraph;
    private Checkbox cbBarGraph;
    private Label lScale;
    private FloatTextField scaleField;

    public GraphDisplayPanel() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (GraphDisplayPanel.this.mainPanel != null) {
                    GraphDisplayPanel.this.setAllBounds();
                    GraphDisplayPanel.this.UpdateDisplay();
                }
            }
        });
        this.setBackground(Color.lightGray);
        this.mainPanel = new Panel();
        this.titleCanvas = new GraphTitleCanvas();
        this.yAxisCanvas = new GraphYAxisCanvas();
        this.wAxisCanvas = new GraphWAxisCanvas();
        this.xAxisCanvas = new GraphXAxisCanvas();
        this.displayCanvas = new GraphDisplayCanvas();
        this.HSB = new Scrollbar(0, 0, 1, 0, 1);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(Analysis.background);
        this.mainPanel.setForeground(Analysis.foreground);
        this.mainPanel.add(this.titleCanvas);
        this.mainPanel.add(this.yAxisCanvas);
        this.mainPanel.add(this.wAxisCanvas);
        this.mainPanel.add(this.xAxisCanvas);
        this.mainPanel.add(this.displayCanvas);
        this.mainPanel.add(this.HSB);
        this.HSB.setBackground(Color.lightGray);
        this.HSB.addAdjustmentListener(this);
        this.lScale = new Label("X-Axis Scale: ", 1);
        this.scaleField = new FloatTextField(1.0f, 5);
        this.scaleField.addActionListener(this);
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cbLineGraph = new Checkbox("Line Graph", false, checkboxGroup);
        this.cbBarGraph = new Checkbox("Bar Graph", true, checkboxGroup);
        this.cbLineGraph.addItemListener(this);
        this.cbBarGraph.addItemListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.cbLineGraph, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.cbBarGraph, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.bDecreaseX, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.lScale, gridBagConstraints, 3, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.scaleField, gridBagConstraints, 4, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.bIncreaseX, gridBagConstraints, 5, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.bResetX, gridBagConstraints, 6, 0, 1, 1, 1, 0);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(this, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 10, 10, 10, 10);
        Util.gblAdd(this, panel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 10, 10, 10, 10);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        float f = this.data.scale;
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bDecreaseX) {
                if ((double)(f = (float)((int)(f * 4.0f) - 1) / 4.0f) < 1.0) {
                    f = 1.0f;
                }
            } else if (button == this.bIncreaseX) {
                f = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (button == this.bResetX) {
                f = 1.0f;
            }
            this.scaleField.setText("" + f);
        } else {
            f = this.scaleField.getValue();
        }
        if (f > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        int n = this.displayCanvas.getSize().width;
        int n2 = (int)(f * (float)n);
        this.HSB.setMaximum(n2);
        this.data.scale = f;
        this.setAllBounds();
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }

    public int getDCW() {
        return this.displayCanvas.getSize().width;
    }

    public int getHSBValue() {
        return this.HSB.getValue();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 350);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.data == null) {
            return;
        }
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (checkbox == this.cbLineGraph) {
            this.data.graphtype = 20;
        } else if (checkbox == this.cbBarGraph) {
            this.data.graphtype = 21;
        }
        this.setAllBounds();
        this.UpdateDisplay();
    }

    public void paint(Graphics graphics) {
        if (graphics instanceof PrinterGraphics) {
            this.mainPanel.setBackground(Color.white);
        } else {
            this.mainPanel.setBackground(Analysis.background);
        }
        super.paint(graphics);
    }

    public void refreshDisplay() {
        this.titleCanvas.repaint();
        this.yAxisCanvas.repaint();
        this.xAxisCanvas.repaint();
        this.wAxisCanvas.repaint();
        this.displayCanvas.repaint();
        this.mainPanel.setBackground(Analysis.background);
        this.mainPanel.repaint();
    }

    public void PrintGraph(Graphics graphics, PrintJob printJob) {
        int n;
        int n2;
        Dimension dimension = this.mainPanel.getSize();
        Dimension dimension2 = printJob.getPageDimension();
        if (dimension2.width < dimension2.height) {
            n2 = (int)(0.7 * (double)dimension2.width / 8.5);
            n = (int)(0.7 * (double)dimension2.height / 11.0);
        } else {
            n2 = (int)(0.7 * (double)dimension2.width / 11.0);
            n = (int)(0.7 * (double)dimension2.height / 8.5);
        }
        int n3 = dimension2.width - 2 * n2;
        int n4 = dimension2.height - 2 * n;
        this.mainPanel.setSize(n3, n4);
        graphics.translate(n2, n);
        this.setAllBounds();
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.printAll(graphics);
        this.mainPanel.setSize(dimension);
        this.setAllBounds();
        this.mainPanel.setBackground(Analysis.background);
    }

    public void setAllBounds() {
        if (this.data == null) {
            return;
        }
        int n = this.mainPanel.getSize().width;
        int n2 = this.mainPanel.getSize().height;
        int n3 = this.titleCanvas.getPreferredHeight();
        int n4 = this.yAxisCanvas.getPreferredWidth();
        int n5 = this.wAxisCanvas.getPreferredWidth();
        int n6 = this.xAxisCanvas.getPreferredHeight();
        int n7 = 20;
        int n8 = n - n4 - n5;
        int n9 = n2 - n3 - n6 - n7;
        this.data.offset2 = n6;
        this.titleCanvas.setBounds(n4, 0, n8, n3);
        this.yAxisCanvas.setBounds(0, n3, n4, n9 + n6);
        this.wAxisCanvas.setBounds(n - n5, n3, n5, n9 + n6);
        this.xAxisCanvas.setBounds(n4, n3 + n9, n8, n6);
        this.displayCanvas.setBounds(n4, n3, n8, n9);
        this.HSB.setBounds(n4, n2 - n7, n8, n7);
        this.HSB.setMaximum((int)(this.data.scale * (float)n8));
        this.HSB.setVisibleAmount(n8);
        this.HSB.setBlockIncrement(n8);
        if (this.data.scale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
    }

    public void setGraphData(GraphData graphData) {
        this.data = graphData;
        this.titleCanvas.setData(graphData);
        this.yAxisCanvas.setData(graphData);
        this.wAxisCanvas.setData(graphData);
        this.xAxisCanvas.setData(graphData);
        this.displayCanvas.setData(graphData);
    }

    public void UpdateDisplay() {
        this.titleCanvas.repaint();
        this.yAxisCanvas.repaint();
        this.wAxisCanvas.repaint();
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }
}

