/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import projections.gui.Analysis;
import projections.gui.BItem;
import projections.gui.GraphControlPanel;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.GraphWindow;
import projections.gui.OrderedIntList;
import projections.gui.ZItem;

public class GraphData {
    static final int PROCESSOR = 0;
    static final int INTERVAL = 1;
    static final int TIME = 10;
    static final int MSGS = 11;
    static final int BOTH = 12;
    static final int LINE = 20;
    static final int BAR = 21;
    protected int intervalStart;
    protected int intervalEnd;
    protected int numUserEntries;
    protected int graphtype;
    protected int xmode;
    protected int ymode;
    protected int minx;
    protected int maxx;
    protected int offset;
    protected int offset2;
    protected int offset3;
    protected float scale;
    protected double yscale;
    protected double wscale;
    protected double xscale;
    private float colorindex;
    private float colorvalue;
    private boolean colorflag = false;
    protected ZItem[] systemUsage;
    protected ZItem[][] systemMsgs;
    protected ZItem[][] userEntry;
    protected ZItem[] onGraph;
    protected BItem processor;
    protected BItem interval;
    protected GraphControlPanel controlPanel;
    protected GraphLegendPanel legendPanel;
    protected GraphDisplayPanel displayPanel;
    protected GraphWindow graphWindow;
    protected OrderedIntList origProcList;

    public GraphData(long l, int n, int n2, OrderedIntList orderedIntList) {
        int n3;
        this.intervalStart = n;
        this.intervalEnd = n2;
        int n4 = this.intervalEnd - this.intervalStart + 1;
        this.yscale = 1.0;
        this.wscale = 1.0;
        this.offset = 10;
        this.offset2 = 0;
        this.offset3 = 0;
        this.numUserEntries = Analysis.getNumUserEntries();
        this.colorvalue = 0.0f;
        this.colorindex = 1.0f / (float)(this.numUserEntries + 7);
        this.graphtype = 21;
        this.xmode = 1;
        this.ymode = 11;
        this.processor = new BItem();
        this.origProcList = orderedIntList;
        this.processor.list = orderedIntList;
        this.processor.string = this.processor.list.listToString();
        this.processor.num = orderedIntList.size();
        String[] stringArray = new String[]{"Queue Size", "Processor Usage(%)", "Idle Time(%)"};
        this.systemUsage = new ZItem[3];
        for (int i = 0; i < 3; ++i) {
            this.systemUsage[i] = new ZItem();
            this.systemUsage[i].name = stringArray[i];
            this.systemUsage[i].exists = null != Analysis.getSystemUsageData(i);
            float f = (float)(1.0 - (double)i * 0.3);
            this.systemUsage[i].color = new Color(f, f, f);
            if (i == 1) {
                this.systemUsage[i].state = true;
            }
            if (i == 0) {
                this.systemUsage[i].type = "Msgs";
                this.systemUsage[i].ymode = 11;
                continue;
            }
            this.systemUsage[i].type = "%";
            this.systemUsage[i].ymode = 12;
        }
        this.onGraph = new ZItem[1];
        this.onGraph[0] = this.systemUsage[1];
        String[] stringArray2 = new String[]{"New Chare", "For Chare", "New Group", "Load Balancing", "Quiescence"};
        String[] stringArray3 = new String[]{"Creation", "Processing", "Time"};
        this.systemMsgs = new ZItem[5][3];
        for (int i = 0; i < 5; ++i) {
            for (n3 = 0; n3 < 3; ++n3) {
                this.systemMsgs[i][n3] = new ZItem();
                this.systemMsgs[i][n3].name = stringArray2[i];
                this.systemMsgs[i][n3].type = stringArray3[n3];
                this.systemMsgs[i][n3].exists = Analysis.hasSystemMsgsData(i, n3);
                if (n3 == 0) {
                    this.systemMsgs[i][n3].color = this.nextColor();
                    this.systemMsgs[i][n3].ymode = 11;
                    continue;
                }
                if (n3 == 1) {
                    this.systemMsgs[i][n3].color = this.systemMsgs[i][0].color.darker();
                    this.systemMsgs[i][n3].ymode = 11;
                    continue;
                }
                if (n3 != 2) continue;
                this.systemMsgs[i][n3].color = this.systemMsgs[i][0].color;
                this.systemMsgs[i][n3].ymode = 10;
            }
        }
        String[][] stringArray4 = Analysis.getEntryNames();
        this.userEntry = new ZItem[this.numUserEntries][3];
        for (n3 = 0; n3 < this.numUserEntries; ++n3) {
            for (int i = 0; i < 3; ++i) {
                this.userEntry[n3][i] = new ZItem();
                this.userEntry[n3][i].name = stringArray4[n3][0];
                this.userEntry[n3][i].type = stringArray3[i];
                this.userEntry[n3][i].parent = stringArray4[n3][1];
                this.userEntry[n3][i].exists = Analysis.hasUserEntryData(n3, i);
                if (i == 0) {
                    this.userEntry[n3][i].color = this.nextColor();
                    this.userEntry[n3][i].ymode = 11;
                    continue;
                }
                if (i == 1) {
                    this.userEntry[n3][i].color = this.userEntry[n3][0].color.darker();
                    this.userEntry[n3][i].ymode = 11;
                    continue;
                }
                if (i != 2) continue;
                this.userEntry[n3][i].color = this.userEntry[n3][0].color;
                this.userEntry[n3][i].ymode = 10;
            }
        }
        this.initData(n4, l);
    }

    public void initData(int n, long l) {
        int n2;
        int n3;
        int n4;
        this.scale = 1.0f;
        this.interval = new BItem();
        this.interval.num = n;
        this.interval.size = l;
        this.interval.list = new OrderedIntList();
        for (n4 = this.intervalStart; n4 <= this.intervalEnd; ++n4) {
            this.interval.list.insert(n4);
        }
        this.interval.string = this.interval.list.listToString();
        n4 = this.origProcList.size();
        for (n3 = 0; n3 < 3; ++n3) {
            if (null == Analysis.getSystemUsageData(n3)) continue;
            this.systemUsage[n3].data = Analysis.getSystemUsageData(n3);
            this.systemUsage[n3].curPData = new int[n4];
            this.systemUsage[n3].curIData = new int[this.interval.num];
        }
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                if (!Analysis.hasSystemMsgsData(n3, n2)) continue;
                this.systemMsgs[n3][n2].data = Analysis.getSystemMsgsData(n3, n2);
                this.systemMsgs[n3][n2].curPData = new int[n4];
                this.systemMsgs[n3][n2].curIData = new int[this.interval.num];
            }
        }
        for (n3 = 0; n3 < this.numUserEntries; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                if (!Analysis.hasUserEntryData(n3, n2)) continue;
                this.userEntry[n3][n2].data = Analysis.getUserEntryData(n3, n2);
                this.userEntry[n3][n2].curPData = new int[n4];
                this.userEntry[n3][n2].curIData = new int[this.interval.num];
            }
        }
        this.setData();
    }

    private Color nextColor() {
        Color color = Color.getHSBColor((float)((double)this.colorvalue * 0.173 % 1.0), (float)(1.0 - 0.6 * ((double)this.colorvalue * 0.729 % 1.0)), 1.0f);
        this.colorvalue = (float)((double)this.colorvalue + 1.0);
        return color;
    }

    private int setCurIData(ZItem zItem) {
        int n = 0;
        for (int i = this.intervalStart; i <= this.intervalEnd; ++i) {
            int n2;
            zItem.curIData[i - this.intervalStart] = 0;
            if (!this.interval.list.contains(i)) continue;
            int n3 = 0;
            this.processor.list.reset();
            int n4 = 0;
            while ((n2 = this.processor.list.nextElement()) >= 0) {
                if (zItem.data[n4] == null) continue;
                int n5 = i - this.intervalStart;
                zItem.curIData[n5] = zItem.curIData[n5] + zItem.data[n4][i - this.intervalStart];
                ++n3;
                ++n4;
            }
            if (zItem.ymode == 12) {
                if (n3 == 0) continue;
                int n6 = i - this.intervalStart;
                zItem.curIData[n6] = zItem.curIData[n6] / n3;
                continue;
            }
            n = Math.max(zItem.curIData[i - this.intervalStart], n);
        }
        return n;
    }

    private int setCurPData(ZItem zItem) {
        int n = 0;
        int n2 = this.processor.list.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            zItem.curPData[i] = 0;
            if (zItem.data[i] == null) continue;
            int n4 = 0;
            this.interval.list.reset();
            while ((n3 = this.interval.list.nextElement()) >= 0) {
                int n5 = i;
                zItem.curPData[n5] = zItem.curPData[n5] + zItem.data[i][n3 - this.intervalStart];
                ++n4;
            }
            if (zItem.ymode == 12) {
                int n6 = i;
                zItem.curPData[n6] = zItem.curPData[n6] / n4;
                continue;
            }
            n = Math.max(zItem.curPData[i], n);
        }
        return n;
    }

    public void setData() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.onGraph.length; ++i) {
            if (this.onGraph[i] == null) {
                System.out.println("onGraph[" + i + "/" + this.onGraph.length + "]==null");
                continue;
            }
            if (this.onGraph[i].ymode == 12) {
                this.setCurPData(this.onGraph[i]);
                this.setCurIData(this.onGraph[i]);
                continue;
            }
            if (this.onGraph[i].ymode == 10) {
                n2 = Math.max(this.setCurPData(this.onGraph[i]), n2);
                n4 = Math.max(this.setCurIData(this.onGraph[i]), n4);
                continue;
            }
            n = Math.max(this.setCurPData(this.onGraph[i]), n);
            n3 = Math.max(this.setCurIData(this.onGraph[i]), n3);
        }
        this.processor.maxTime = n2;
        this.processor.maxMsgs = n;
        this.interval.maxTime = n4;
        this.interval.maxMsgs = n3;
    }
}

