/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class CommWindow
extends GenericGraphWindow
implements ItemListener {
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] exclusiveRecv;
    private double[][] exclusiveBytesRecv;
    private int[][] hopCount;
    private double[][] avgHopCount;
    private double[][] avgPeHopCount;
    private ArrayList histogram;
    private int[] histArray;
    private String currentArrayName;
    private String[][] popupText;
    private String[][] EPNames;
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel blueGenePanel;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox histogramCB;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox recvExclusive;
    private Checkbox recvExclusiveBytes;
    private Checkbox hopCountCB;
    private Checkbox peHopCountCB;
    private CommWindow thisWindow;
    private OrderedIntList peList;

    void windowInit() {
        super.windowInit();
    }

    public CommWindow(MainWindow mainWindow, Integer n) {
        super("Projections Communication - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.setLayout(this.mainPanel);
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    public void repaint() {
        super.refreshGraph();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (checkbox == this.sentMsgs) {
                this.setDataSource("Total #Msgs Sent", this.sentMsgCount, (GenericGraphWindow)this);
                this.setPopupText("sentMsgCount");
                this.setYAxis("Messages Sent", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.sentBytes) {
                this.setDataSource("Total Bytes Sent", this.sentByteCount, (GenericGraphWindow)this);
                this.setPopupText("sentByteCount");
                this.setYAxis("Bytes Sent", "bytes");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.receivedMsgs) {
                this.setDataSource("Total #Msgs Received", this.receivedMsgCount, (GenericGraphWindow)this);
                this.setPopupText("receivedMsgCount");
                this.setYAxis("Messages Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.receivedBytes) {
                this.setDataSource("Total Bytes Received", this.receivedByteCount, (GenericGraphWindow)this);
                this.setPopupText("receivedByteCount");
                this.setYAxis("Bytes Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.recvExclusive) {
                this.setDataSource("#Msgs Received Externally", this.exclusiveRecv, (GenericGraphWindow)this);
                this.setPopupText("exclusiveRecv");
                this.setYAxis("Messages Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.recvExclusiveBytes) {
                this.setDataSource("Bytes Received Externally", this.exclusiveBytesRecv, (GenericGraphWindow)this);
                this.setPopupText("exclusiveBytesRecv");
                this.setYAxis("Bytes Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.hopCountCB) {
                if (this.avgHopCount == null) {
                    this.avgHopCount = this.averageHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Entry Point", this.avgHopCount, (GenericGraphWindow)this);
                this.setPopupText("avgHopCount");
                this.setYAxis("Average Message Hop Counts", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (checkbox == this.peHopCountCB) {
                if (this.avgPeHopCount == null) {
                    this.avgPeHopCount = this.averagePEHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Processor", this.avgPeHopCount, (GenericGraphWindow)this);
                this.setPopupText("avgPeHopCount");
                this.setYAxis("Average Message Hop Counts (by PE)", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void setPopupText(String string) {
        this.currentArrayName = string;
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0 || this.currentArrayName == null) {
            return null;
        }
        if (this.EPNames == null) {
            this.EPNames = Analysis.getEntryNames();
        }
        String[] stringArray = new String[3];
        if (this.currentArrayName.equals("sentMsgCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.sentMsgCount[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Bytes = " + this.sentByteCount[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.receivedMsgCount[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.receivedByteCount[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("exclusiveRecv")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.exclusiveRecv[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("exclusiveBytesRecv")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Bytes = " + this.exclusiveBytesRecv[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("avgHopCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.avgHopCount[n][n2];
            stringArray[2] = "Processor = " + this.xAxis.getIndexName(n);
        } else if (this.currentArrayName.equals("avgPeHopCount")) {
            stringArray[0] = "Count = " + this.avgPeHopCount[n][n2];
            stringArray[1] = "Processor = " + this.xAxis.getIndexName(n);
            stringArray[2] = "";
        }
        return stringArray;
    }

    protected void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.graphPanel = this.getMainPanel();
        this.checkBoxPanel = new JPanel();
        if (MainWindow.BLUEGENE) {
            this.blueGenePanel = new JPanel();
        }
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent To", checkboxGroup, true);
        this.sentBytes = new Checkbox("Bytes Sent To", checkboxGroup, false);
        this.receivedMsgs = new Checkbox("Msgs Recv By", checkboxGroup, false);
        this.receivedBytes = new Checkbox("Bytes Recv By", checkboxGroup, false);
        this.recvExclusive = new Checkbox("External Msgs Recv By", checkboxGroup, false);
        this.recvExclusiveBytes = new Checkbox("External Bytes Recv By", checkboxGroup, false);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB = new Checkbox("Avg Hop Count (EP)", checkboxGroup, false);
            this.peHopCountCB = new Checkbox("Avg Hop Count (procs)", checkboxGroup, false);
        }
        this.sentMsgs.addItemListener(this);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes.addItemListener(this);
        this.recvExclusive.addItemListener(this);
        this.recvExclusiveBytes.addItemListener(this);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB.addItemListener(this);
            this.peHopCountCB.addItemListener(this);
        }
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusive, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusiveBytes, gridBagConstraints, 5, 0, 1, 1, 1, 1);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.blueGenePanel, this.hopCountCB, gridBagConstraints, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.blueGenePanel, this.peHopCountCB, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        }
        Util.gblAdd(this.mainPanel, this.graphPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gridBagConstraints, 0, 2, 1, 1, 0, 0);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.mainPanel, this.blueGenePanel, gridBagConstraints, 0, 3, 1, 1, 0, 0);
        }
    }

    public void setGraphSpecificData() {
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    CommWindow.access$002(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$102(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$202(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$302(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$402(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$502(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    if (MainWindow.BLUEGENE) {
                        CommWindow.access$602(CommWindow.this, new int[CommWindow.this.validPEs.size()][]);
                    } else {
                        CommWindow.access$602(CommWindow.this, null);
                    }
                    CommWindow.this.getData();
                    return null;
                }

                public void finished() {
                    CommWindow.this.setDataSource("Communications", CommWindow.this.sentMsgCount, (GenericGraphWindow)CommWindow.this.thisWindow);
                    CommWindow.this.setPopupText("sentMsgCount");
                    CommWindow.this.setYAxis("Messages Sent", "");
                    CommWindow.this.setXAxis("Processor", CommWindow.this.peList);
                    CommWindow.this.thisWindow.setVisible(true);
                    CommWindow.this.thisWindow.repaint();
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        super.getDialogData();
    }

    public void setDialogData() {
        super.setDialogData();
    }

    public void getData() {
        int n;
        int n2;
        LogEntryData logEntryData = new LogEntryData();
        this.peList = this.validPEs.copyOf();
        int n3 = this.peList.size();
        int n4 = Analysis.getNumUserEntries();
        this.histogram = new ArrayList();
        int n5 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Reading log files", "", 0, n3);
        while (this.peList.hasMoreElements()) {
            n2 = this.peList.nextElement();
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            progressMonitor.setNote("[PE: " + n2 + " ] Reading data.");
            progressMonitor.setProgress(n5 + 1);
            this.validate();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n2), Analysis.getVersion());
            try {
                this.sentMsgCount[n5] = new double[n4];
                this.sentByteCount[n5] = new double[n4];
                this.receivedMsgCount[n5] = new double[n4];
                this.receivedByteCount[n5] = new double[n4];
                this.exclusiveRecv[n5] = new double[n4];
                this.exclusiveBytesRecv[n5] = new double[n4];
                if (MainWindow.BLUEGENE) {
                    this.hopCount[n5] = new int[n4];
                }
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (logEntryData.time <= this.endTime || logEntryData.type != 1 && logEntryData.type != 2) {
                    int n6;
                    genericLogReader.nextEvent(logEntryData);
                    if (logEntryData.type == 1) {
                        n6 = logEntryData.entry;
                        double[] dArray = this.sentMsgCount[n5];
                        int n7 = n6;
                        dArray[n7] = dArray[n7] + 1.0;
                        double[] dArray2 = this.sentByteCount[n5];
                        int n8 = n6;
                        dArray2[n8] = dArray2[n8] + (double)logEntryData.msglen;
                        this.histogram.add(new Integer(logEntryData.msglen));
                        continue;
                    }
                    if (logEntryData.type != 2) continue;
                    n6 = logEntryData.entry;
                    double[] dArray = this.receivedMsgCount[n5];
                    int n9 = n6;
                    dArray[n9] = dArray[n9] + 1.0;
                    double[] dArray3 = this.receivedByteCount[n5];
                    int n10 = n6;
                    dArray3[n10] = dArray3[n10] + (double)logEntryData.msglen;
                    if (logEntryData.pe == n2) continue;
                    double[] dArray4 = this.exclusiveRecv[n5];
                    int n11 = n6;
                    dArray4[n11] = dArray4[n11] + 1.0;
                    double[] dArray5 = this.exclusiveBytesRecv[n5];
                    int n12 = n6;
                    dArray5[n12] = dArray5[n12] + (double)logEntryData.msglen;
                    if (!MainWindow.BLUEGENE) continue;
                    int[] nArray = this.hopCount[n5];
                    int n13 = n6;
                    nArray[n13] = nArray[n13] + this.manhattenDistance(n2, logEntryData.pe);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
                iOException.printStackTrace();
            }
            ++n5;
        }
        progressMonitor.close();
        n2 = (Integer)this.histogram.get(0);
        int n14 = (Integer)this.histogram.get(0);
        for (n = 1; n < this.histogram.size(); ++n) {
            if ((Integer)this.histogram.get(n) < n14) {
                n14 = (Integer)this.histogram.get(n);
            }
            if ((Integer)this.histogram.get(n) <= n2) continue;
            n2 = (Integer)this.histogram.get(n);
        }
        this.histArray = new int[n2 + 1];
        for (n = 0; n < Array.getLength(this.histArray); ++n) {
            this.histArray[n] = 0;
        }
        for (int i = 0; i < this.histogram.size(); ++i) {
            int n15 = n = ((Integer)this.histogram.get(i)).intValue();
            this.histArray[n15] = this.histArray[n15] + 1;
        }
    }

    private int manhattenDistance(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int[] nArray = this.peToTriple(n);
        int[] nArray2 = this.peToTriple(n2);
        for (int i = 0; i < 3; ++i) {
            n4 = nArray[i] < nArray2[i] ? nArray2[i] - nArray[i] : nArray[i] - nArray2[i];
            if ((double)n4 > (double)MainWindow.BLUEGENE_SIZE[i] / 2.0) {
                n4 = MainWindow.BLUEGENE_SIZE[i] - n4;
            }
            n3 += n4;
        }
        return n3;
    }

    private int[] peToTriple(int n) {
        int[] nArray = new int[3];
        nArray[2] = n / (MainWindow.BLUEGENE_SIZE[1] * MainWindow.BLUEGENE_SIZE[0]);
        nArray[1] = n / MainWindow.BLUEGENE_SIZE[0] - nArray[2] * MainWindow.BLUEGENE_SIZE[0];
        nArray[0] = n % MainWindow.BLUEGENE_SIZE[0];
        return nArray;
    }

    private double[][] averageHops(int[][] nArray, double[][] dArray) {
        double[][] dArray2 = new double[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                dArray2[i][j] = dArray[i][j] > 0.0 ? (double)nArray[i][j] / dArray[i][j] : 0.0;
            }
        }
        return dArray2;
    }

    private double[][] averagePEHops(int[][] nArray, double[][] dArray) {
        double[][] dArray2 = new double[nArray.length][1];
        double[] dArray3 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j];
                double[] dArray4 = dArray2[i];
                dArray4[0] = dArray4[0] + (double)nArray[i][j];
            }
            if (!(dArray3[i] > 0.0)) continue;
            double[] dArray5 = dArray2[i];
            dArray5[0] = dArray5[0] / dArray3[i];
        }
        return dArray2;
    }

    public static int[] peToTripleA(int n) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{8, 8, 16};
        System.out.println("BG triplet = " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]);
        nArray[2] = n / (nArray2[0] * nArray2[1]);
        nArray[1] = n / nArray2[0] - nArray[2] * nArray2[0];
        nArray[0] = n % nArray2[0];
        return nArray;
    }

    public static int manhattenDistanceA(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[]{8, 8, 16};
        int[] nArray2 = CommWindow.peToTripleA(n2);
        int[] nArray3 = CommWindow.peToTripleA(n);
        System.out.println("Source triple = " + nArray3[0] + " " + nArray3[1] + " " + nArray3[2]);
        System.out.println("Dest triple = " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]);
        for (int i = 0; i < 3; ++i) {
            n4 = nArray2[i] < nArray3[i] ? nArray3[i] - nArray2[i] : nArray2[i] - nArray3[i];
            if ((double)n4 > (double)nArray[i] / 2.0) {
                n4 = nArray[i] - n4;
            }
            n3 += n4;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        int n = CommWindow.manhattenDistanceA(1018, 1023);
        System.out.println(n);
        n = CommWindow.manhattenDistanceA(1018, 1020);
        System.out.println(n);
        n = CommWindow.manhattenDistanceA(1018, 972);
        System.out.println(n);
        n = CommWindow.manhattenDistanceA(1018, 996);
        System.out.println(n);
        n = CommWindow.manhattenDistanceA(442, 663);
        System.out.println(n);
        n = CommWindow.manhattenDistanceA(1018, 324);
        System.out.println(n);
    }

    static /* synthetic */ double[][] access$002(CommWindow commWindow, double[][] dArray) {
        commWindow.sentMsgCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$102(CommWindow commWindow, double[][] dArray) {
        commWindow.sentByteCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$202(CommWindow commWindow, double[][] dArray) {
        commWindow.receivedMsgCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$302(CommWindow commWindow, double[][] dArray) {
        commWindow.receivedByteCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$402(CommWindow commWindow, double[][] dArray) {
        commWindow.exclusiveRecv = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$502(CommWindow commWindow, double[][] dArray) {
        commWindow.exclusiveBytesRecv = dArray;
        return dArray;
    }

    static /* synthetic */ int[][] access$602(CommWindow commWindow, int[][] nArray) {
        commWindow.hopCount = nArray;
        return nArray;
    }
}

