/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.gui.JIntTextField;
import projections.gui.JLongTextField;
import projections.gui.JTimeTextField;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class BinDialog
extends RangeDialog {
    protected JTabbedPane binPanel;
    protected JPanel timeBinPanel;
    protected JPanel msgBinPanel;
    protected JLabel timeNumBinsLabel;
    protected JLabel timeBinSizeLabel;
    protected JLabel timeMinBinSizeLabel;
    protected JLabel timeBinRangeLabel;
    protected JIntTextField timeNumBinsField;
    protected JTimeTextField timeBinSizeField;
    protected JTimeTextField timeMinBinSizeField;
    protected JLabel msgNumBinsLabel;
    protected JLabel msgBinSizeLabel;
    protected JLabel msgMinBinSizeLabel;
    protected JLabel msgBinRangeLabel;
    protected JIntTextField msgNumBinsField;
    protected JLongTextField msgBinSizeField;
    protected JLongTextField msgMinBinSizeField;
    protected int timeNumBins = 100;
    protected long timeBinSize = 1000L;
    protected long timeMinBinSize = 0L;
    protected int msgNumBins = 200;
    protected long msgBinSize = 100L;
    protected long msgMinBinSize = 0L;
    private static final int NUM_TYPES = 2;
    private static final int TIME_DATA = 0;
    private static final int BYTES_DATA = 1;
    private DecimalFormat _format = new DecimalFormat();

    public BinDialog(ProjectionsWindow projectionsWindow, String string) {
        super(projectionsWindow, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
            } else if (jButton == this.bUpdate) {
                this.setBinRangeText(0);
                this.setBinRangeText(1);
            }
        }
        super.actionPerformed(actionEvent);
    }

    JPanel createMainLayout() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = super.createMainLayout();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.timeBinPanel = new JPanel();
        this.timeBinPanel.setLayout(gridBagLayout);
        this.timeBinPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "TIME-BASED BINS"));
        this.timeNumBinsLabel = new JLabel("# of Time Bins:", 2);
        this.timeNumBinsField = new JIntTextField(this.timeNumBins, 5);
        this.timeNumBinsField.addActionListener(this);
        this.timeNumBinsField.addKeyListener(this);
        this.timeNumBinsField.addFocusListener(this);
        this.timeBinSizeLabel = new JLabel("Time Bin Size:", 2);
        this.timeBinSizeField = new JTimeTextField(this.timeBinSize, 12);
        this.timeBinSizeField.addActionListener(this);
        this.timeBinSizeField.addKeyListener(this);
        this.timeBinSizeField.addFocusListener(this);
        this.timeMinBinSizeLabel = new JLabel("Starting Bin Size:", 2);
        this.timeMinBinSizeField = new JTimeTextField(this.timeMinBinSize, 12);
        this.timeMinBinSizeField.addActionListener(this);
        this.timeMinBinSizeField.addKeyListener(this);
        this.timeMinBinSizeField.addFocusListener(this);
        this.timeBinRangeLabel = new JLabel("", 2);
        this.setBinRangeText(0);
        Util.gblAdd(this.timeBinPanel, this.timeNumBinsLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeNumBinsField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinSizeLabel, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinSizeField, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeMinBinSizeLabel, gridBagConstraints, 0, 1, 2, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeMinBinSizeField, gridBagConstraints, 1, 1, 2, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinRangeLabel, gridBagConstraints, 0, 2, 4, 1, 1, 1);
        this.msgBinPanel = new JPanel();
        this.msgBinPanel.setLayout(gridBagLayout);
        this.msgBinPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "MESSAGE-BASED BINS"));
        this.msgNumBinsLabel = new JLabel("# of Msg Bins:", 2);
        this.msgNumBinsField = new JIntTextField(this.msgNumBins, 5);
        this.msgNumBinsField.addActionListener(this);
        this.msgNumBinsField.addKeyListener(this);
        this.msgNumBinsField.addFocusListener(this);
        this.msgBinSizeLabel = new JLabel("Bin Size (bytes):", 2);
        this.msgBinSizeField = new JLongTextField(this.msgBinSize, 12);
        this.msgBinSizeField.addActionListener(this);
        this.msgBinSizeField.addKeyListener(this);
        this.msgBinSizeField.addFocusListener(this);
        this.msgMinBinSizeLabel = new JLabel("Starting Bin Size:", 2);
        this.msgMinBinSizeField = new JLongTextField(this.msgMinBinSize, 12);
        this.msgMinBinSizeField.addActionListener(this);
        this.msgMinBinSizeField.addKeyListener(this);
        this.msgMinBinSizeField.addFocusListener(this);
        this.msgBinRangeLabel = new JLabel("", 2);
        this.setBinRangeText(1);
        Util.gblAdd(this.msgBinPanel, this.msgNumBinsLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgNumBinsField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinSizeLabel, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinSizeField, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgMinBinSizeLabel, gridBagConstraints, 0, 1, 2, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgMinBinSizeField, gridBagConstraints, 1, 1, 2, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinRangeLabel, gridBagConstraints, 0, 2, 4, 1, 1, 1);
        this.binPanel = new JTabbedPane();
        this.binPanel.addTab("Time", null, this.timeBinPanel, "Time-based bins");
        this.binPanel.addTab("Msgs", null, this.msgBinPanel, "Message Sizes");
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.binPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JIntTextField) {
            if (jTextField == this.timeNumBinsField) {
                this.timeNumBins = this.timeNumBinsField.getValue();
                this.setBinRangeText(0);
            } else if (jTextField == this.msgNumBinsField) {
                this.msgNumBins = this.msgNumBinsField.getValue();
                this.setBinRangeText(1);
            }
        } else if (jTextField instanceof JLongTextField) {
            if (jTextField == this.msgBinSizeField) {
                this.msgBinSize = this.msgBinSizeField.getValue();
            } else if (jTextField == this.msgMinBinSizeField) {
                this.msgMinBinSize = this.msgMinBinSizeField.getValue();
            }
            this.setBinRangeText(1);
        } else if (jTextField instanceof JTimeTextField) {
            if (jTextField == this.timeBinSizeField) {
                this.timeBinSize = this.timeBinSizeField.getValue();
            } else if (jTextField == this.timeMinBinSizeField) {
                this.timeMinBinSize = this.timeMinBinSizeField.getValue();
            }
            this.setBinRangeText(0);
        }
        super.updateData(jTextField);
    }

    JTextField checkConsistent() {
        return super.checkConsistent();
    }

    public boolean isModified() {
        return false;
    }

    void setParameters() {
        super.setParameters();
    }

    void updateFields() {
        super.updateFields();
        this.updateDerived();
    }

    void updateDerived() {
    }

    void setBinRangeText(int n) {
        switch (n) {
            case 0: {
                this.timeBinRangeLabel.setText("Bin size ranges from : " + U.t(this.timeMinBinSizeField.getValue()) + " to " + U.t(this.timeMinBinSizeField.getValue() + (long)this.timeNumBinsField.getValue() * this.timeBinSizeField.getValue()));
                break;
            }
            case 1: {
                this.msgBinRangeLabel.setText("Bin size ranges from : " + this._format.format(this.msgMinBinSizeField.getValue()) + " bytes to " + this._format.format(this.msgMinBinSizeField.getValue() + (long)this.msgNumBinsField.getValue() * this.msgBinSizeField.getValue()) + " bytes.");
            }
        }
    }

    public int getTimeNumBins() {
        return this.timeNumBins;
    }

    public void setTimeNumBins(int n) {
        this.timeNumBins = n;
    }

    public long getTimeBinSize() {
        return this.timeBinSize;
    }

    public void setTimeBinSize(long l) {
        this.timeBinSize = l;
    }

    public long getTimeMinBinSize() {
        return this.timeMinBinSize;
    }

    public void setTimeMinBinSize(long l) {
        this.timeMinBinSize = l;
    }

    public int getMsgNumBins() {
        return this.msgNumBins;
    }

    public void setMsgNumBins(int n) {
        this.msgNumBins = n;
    }

    public long getMsgBinSize() {
        return this.msgBinSize;
    }

    public void setMsgBinSize(long l) {
        this.msgBinSize = l;
    }

    public long getMsgMinBinSize() {
        return this.msgMinBinSize;
    }

    public void setMsgMinBinSize(long l) {
        this.msgMinBinSize = l;
    }
}

