/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;

public class RangeHistory {
    public static final int MAX_ENTRIES = 10;
    private boolean noSource = false;
    private String filename;
    private int numEntries;
    private Vector rangeSet;

    public RangeHistory(String string) {
        this.filename = string + "ranges.hst";
        if (!new File(this.filename).exists()) {
            this.noSource = true;
        }
    }

    public Vector loadRanges() throws IOException {
        String string;
        this.rangeSet = new Vector();
        if (this.noSource) {
            return this.rangeSet;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filename));
        this.numEntries = 0;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("ENTRY")) continue;
            if (this.numEntries >= 10) {
                throw new IOException("Range history overflow!");
            }
            this.rangeSet.add(Long.valueOf(stringTokenizer.nextToken()));
            this.rangeSet.add(Long.valueOf(stringTokenizer.nextToken()));
            ++this.numEntries;
        }
        bufferedReader.close();
        return this.rangeSet;
    }

    public void save() throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.filename), true);
        for (int i = 0; i < this.numEntries; ++i) {
            printWriter.print("ENTRY ");
            printWriter.print((Long)this.rangeSet.elementAt(i * 2));
            printWriter.print(" ");
            printWriter.println((Long)this.rangeSet.elementAt(i * 2 + 1));
        }
    }

    public void add(long l, long l2) {
        if (this.numEntries == 10) {
            this.rangeSet.remove(10);
            this.rangeSet.remove(9);
            --this.numEntries;
        }
        this.rangeSet.add(0, new Long(l2));
        this.rangeSet.add(0, new Long(l));
        ++this.numEntries;
    }
}

