/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import projections.analysis.RLEBlock;
import projections.analysis.SumDetailReader;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;

public class IntervalData {
    public static final int NUM_TYPES = 2;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_NUM_MSGS = 1;
    private static SumDetailReader[] summaryDetails;
    private Vector[][][] rawData;
    private int numEPs = 0;
    private int numPEs = Analysis.getNumProcessors();
    private int numIntervals = 0;
    private double intervalSize = 0.0;

    public IntervalData() {
        this.numEPs = Analysis.getNumUserEntries();
        if (Analysis.hasSumDetailData()) {
            summaryDetails = new SumDetailReader[this.numPEs];
            this.rawData = new Vector[2][this.numPEs][];
            OrderedIntList orderedIntList = Analysis.getValidProcessorList(3);
            orderedIntList.reset();
            while (orderedIntList.hasMoreElements()) {
                int n = orderedIntList.nextElement();
                try {
                    IntervalData.summaryDetails[n] = new SumDetailReader(Analysis.getSumDetailName(n), Analysis.getVersion());
                    for (int i = 0; i < 2; ++i) {
                        this.rawData[i][n] = summaryDetails[n].getData(i);
                    }
                    if (this.numIntervals < summaryDetails[n].getNumIntervals()) {
                        this.numIntervals = summaryDetails[n].getNumIntervals();
                    }
                    this.intervalSize = summaryDetails[n].getIntervalSize();
                }
                catch (IOException iOException) {
                    System.err.println("Warning: Failed to read summary detail file for processor " + n);
                }
            }
        }
    }

    private void loadData(int n, int n2, int n3, int n4, int n5, double d) {
        if (d < this.intervalSize ? Analysis.hasLogData() : d > this.intervalSize) {
            // empty if block
        }
    }

    public double[][] getData(int n, int n2) {
        double[][] dArray = new double[this.numEPs][this.numIntervals];
        for (int i = 0; i < this.numEPs; ++i) {
            Iterator iterator = this.rawData[n2][n][i].iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                RLEBlock rLEBlock = (RLEBlock)iterator.next();
                for (int j = 0; j < rLEBlock.count; ++j) {
                    dArray[i][n3 + j] = rLEBlock.value;
                }
                n3 += rLEBlock.count;
            }
        }
        return dArray;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    private void accumulateIntoArray(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6 = 0;
        boolean bl = false;
        Iterator iterator = this.rawData[n][n2][n3].iterator();
        while (iterator.hasNext()) {
            RLEBlock rLEBlock = (RLEBlock)iterator.next();
            int n7 = n6 + rLEBlock.count - 1;
            if (n7 < n4) {
                n6 = n7 + 1;
                continue;
            }
            if (n6 < n4) {
                n6 = n4;
            }
            if (n7 > n5) {
                n7 = n5;
                bl = true;
            }
            for (int i = n6 - n4; i <= n7 - n4; ++i) {
                dArray[i] = rLEBlock.value;
            }
            n6 = n7 + 1;
            if (!bl) continue;
            break;
        }
    }

    public double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        int n4 = Analysis.getNumUserEntries();
        double[][] dArray = new double[n4][n3 - n2 + 1];
        for (int i = 0; i < n4; ++i) {
            orderedIntList.reset();
            for (int j = 0; j < orderedIntList.size(); ++j) {
                int n5 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n5, i, n2, n3, dArray[i]);
            }
        }
        return dArray;
    }

    public Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        Vector<double[]> vector = new Vector<double[]>();
        double[] dArray = null;
        orderedIntList2.reset();
        for (int i = 0; i < orderedIntList2.size(); ++i) {
            dArray = new double[n3 - n2 + 1];
            int n4 = orderedIntList2.nextElement();
            orderedIntList.reset();
            for (int j = 0; j < orderedIntList.size(); ++j) {
                int n5 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n5, n4, n2, n3, dArray);
            }
            vector.add(dArray);
        }
        return vector;
    }
}

