/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.Consumer;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import java.util.Vector;

public class PConsumer
extends Consumer {
    private PList finalList;
    private String lastComment;
    private PList dest = null;
    private Vector destStack = new Vector();

    public PList getList() {
        return this.finalList;
    }

    private void applyComment(PAbstract pAbstract) {
        if (this.lastComment != null) {
            pAbstract.setName(this.lastComment);
            this.lastComment = null;
        }
    }

    private void destPush() {
        if (this.dest != null) {
            this.destStack.addElement(this.dest);
        }
        this.dest = new PList();
        this.applyComment(this.dest);
    }

    private void destPop() {
        PList pList = this.dest;
        int n = this.destStack.size() - 1;
        if (n >= 0) {
            this.dest = (PList)this.destStack.elementAt(n);
            this.destStack.removeElementAt(n);
            if (pList != null) {
                this.dest.add(pList);
            }
        } else {
            this.finalList = this.dest;
            this.dest = null;
        }
    }

    private void add(PAbstract pAbstract) {
        this.applyComment(pAbstract);
        if (this.dest != null) {
            this.dest.add(pAbstract);
        }
    }

    public void listComment(String string) {
        this.lastComment = string;
    }

    public void listSync(int n) {
        switch (n) {
            case 1898971136: {
                this.destPush();
                break;
            }
            case 1915748352: {
                this.destPop();
                break;
            }
            case 0x71100000: {
                this.destPush();
                this.destPush();
                this.dest = null;
                break;
            }
            case 1913651200: {
                this.destPop();
                this.destPop();
                break;
            }
            case 1897922560: {
                this.destPush();
                this.destPush();
                break;
            }
            case 0x72200000: {
                this.destPop();
                this.destPop();
                break;
            }
            case 0x79000000: {
                PList pList = this.dest;
                this.dest = new PList();
                this.dest.setName(pList.getName());
                break;
            }
            case 1880227840: {
                break;
            }
            case 0x70110000: {
                this.destPop();
                this.listComment("[" + this.dest.size() + "]");
                this.destPush();
                break;
            }
        }
    }

    public void listByte(byte[] byArray) {
        this.add(new PString(new String(byArray)));
    }

    public void listInt(int[] nArray) {
        this.add(new PNative(nArray));
    }

    public void listFloat(float[] fArray) {
        this.add(new PNative(fArray));
    }
}

